<?php

namespace App\Entity;

use App\Repository\CollectionnerRepository;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

#[ORM\Entity(repositoryClass: CollectionnerRepository::class)]
class Collectionner
{
    #[ORM\Id]
    #[ORM\ManyToOne(inversedBy: 'collectionners')]
    #[ORM\JoinColumn(name: "collectionneur_id_id", referencedColumnName: 'id', nullable: false)]
    private ?Collectionneur $collectionneurID = null;

    #[ORM\Id]
    #[ORM\ManyToOne(inversedBy: 'collectionners')]
    #[ORM\JoinColumn(name: "piece_modele_id_id", referencedColumnName: 'id', nullable: false)]
    private ?PieceModele $pieceModeleID = null;

    #[ORM\Column]
    #[Assert\Positive(message: "La valeur de la collection doit être positive.")]
    private ?int $qteCollection = null;

    public function getCollectionneurID(): ?Collectionneur
    {
        return $this->collectionneurID;
    }

    public function setCollectionneurID(?Collectionneur $collectionneurID): static
    {
        $this->collectionneurID = $collectionneurID;

        return $this;
    }

    public function getPieceModeleID(): ?PieceModele
    {
        return $this->pieceModeleID;
    }

    public function setPieceModeleID(?PieceModele $pieceModeleID): static
    {
        $this->pieceModeleID = $pieceModeleID;

        return $this;
    }

    public function getQteCollection(): ?int
    {
        return $this->qteCollection;
    }

    public function setQteCollection(int $qteCollection): static
    {
        $this->qteCollection = $qteCollection;

        return $this;
    }
}
