<?php

namespace App\Controller;

use App\Entity\Collectionneur;
use App\Form\CollectionneurType;
use App\Repository\CollectionneurRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route('/collectionneur')]
class CollectionneurController extends AbstractController
{
    #[Route('/', name: 'app_collectionneur_index', methods: ['GET'])]
    public function index(CollectionneurRepository $collectionneurRepository): Response
    {
        return $this->render('collectionneur/index.html.twig', [
            'collectionneurs' => $collectionneurRepository->findBy([], ['id' => 'ASC'] ),
        ]);
    }

    #[Route('/insert', name: 'app_collectionneur_new', methods: ['GET', 'POST'])]
    public function insert(Request $request, EntityManagerInterface $entityManager): Response
    {
        $collectionneur = new Collectionneur();
        $form = $this->createForm(CollectionneurType::class, $collectionneur);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->persist($collectionneur);
            $entityManager->flush();

            return $this->redirectToRoute('app_collectionneur_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('collectionneur/new.html.twig', [
            'collectionneur' => $collectionneur,
            'form' => $form,
        ]);
    }

    #[Route('/{id}', name: 'app_collectionneur_show', methods: ['GET'])]
    public function show(Collectionneur $collectionneur): Response
    {
        return $this->render('collectionneur/show.html.twig', [
            'collectionneur' => $collectionneur,
        ]);
    }

    #[Route('/update/{id}', name: 'app_collectionneur_edit', methods: ['GET', 'POST'])]
    public function update(Request $request, Collectionneur $collectionneur, EntityManagerInterface $entityManager): Response
    {
        $form = $this->createForm(CollectionneurType::class, $collectionneur);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->flush();

            return $this->redirectToRoute('app_collectionneur_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('collectionneur/edit.html.twig', [
            'collectionneur' => $collectionneur,
            'form' => $form,
        ]);
    }

    #[Route('delete/{id}', name: 'app_collectionneur_delete', methods: ['POST'])]
    public function delete(Request $request, Collectionneur $collectionneur, EntityManagerInterface $entityManager): Response
    {
        if ($this->isCsrfTokenValid('delete'.$collectionneur->getId(), $request->request->get('_token'))) {
            $entityManager->remove($collectionneur);
            $entityManager->flush();
        }

        return $this->redirectToRoute('app_collectionneur_index', [], Response::HTTP_SEE_OTHER);
    }
}
