<?php

namespace App\Services;

use App\Entity\PieceModele;

class PieceModeleService
{
    public function getDisplayName(PieceModele $pieceModele): string
    {
        return sprintf('%s - Version : %s, Valeur : %d, Date Frappée : %s, Quantité Frappée : %s',
            $pieceModele->getId(),
            $pieceModele->getPieceVersion(),
            $pieceModele->getPieceValeur(),
            $pieceModele->getPieceDateFrappee()->format('Y-m-d'),
            $pieceModele->getPieceQuantiteFrappee()
        );
    }
}