<?php

namespace App\Form;

use App\Entity\PieceCaracteristique;
use App\Entity\PieceModele;
use App\Services\PieceModeleService;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class PieceCaracteristiqueType extends AbstractType
{
    private PieceModeleService $pieceModeleService;

    public function __construct(PieceModeleService $pieceModeleService)
    {
        $this->pieceModeleService = $pieceModeleService;
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('pieceFaceCommune')
            ->add('pieceMasse')
            ->add('pieceTaille')
            ->add('pieceMateriau')
            ->add('pieceModeleID', EntityType::class, [
                'class' => PieceModele::class,
                'choice_label' => function (PieceModele $pieceModele) {
                   return $this->pieceModeleService->getDisplayName($pieceModele);
                }
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => PieceCaracteristique::class,
        ]);
    }
}
