<?php

namespace App\Form;

use App\Entity\Collectionner;
use App\Entity\Collectionneur;
use App\Entity\PieceModele;
use App\Services\CollectionneurService;
use App\Services\PieceModeleService;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class CollectionnerType extends AbstractType
{

    private CollectionneurService $collectionneurService;
    private PieceModeleService $pieceModeleService;

    public function __construct(CollectionneurService $collectionneurService, PieceModeleService $pieceModeleService)
    {
        $this->collectionneurService = $collectionneurService;
        $this->pieceModeleService = $pieceModeleService;
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('qteCollection')
            ->add('collectionneurID', EntityType::class, [
                'class' => Collectionneur::class,
                'choice_label' => function (Collectionneur $collectionneur) {
                    return $this->collectionneurService->getDisplayName($collectionneur);
                },
            ])
            ->add('pieceModeleID', EntityType::class, [
                'class' => PieceModele::class,
                'choice_label' => function (PieceModele $pieceModele) {
                    return $this->pieceModeleService->getDisplayName($pieceModele);
                },
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'data_class' => Collectionner::class,
        ]);
    }
}
