<?php

namespace App\Entity;

use App\Repository\PiecePaysRepository;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: PiecePaysRepository::class)]
#[ORM\Table(name: "piece_pays")]
class PiecePays
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column(name:"id")]
    private ?int $id = null;

    #[ORM\ManyToOne(inversedBy: 'piecePays')]
    #[ORM\JoinColumn(name:"piece_modele_id_id", nullable: false)]
    private ?PieceModele $pieceModeleID = null;

    #[ORM\Column(name:"pays_nom", length: 250)]
    private ?string $paysNom = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getPieceModeleID(): ?PieceModele
    {
        return $this->pieceModeleID;
    }

    public function setPieceModeleID(?PieceModele $pieceModeleID): static
    {
        $this->pieceModeleID = $pieceModeleID;

        return $this;
    }

    public function getPaysNom(): ?string
    {
        return $this->paysNom;
    }

    public function setPaysNom(string $paysNom): static
    {
        $this->paysNom = $paysNom;

        return $this;
    }
}
