<?php

namespace App\Entity;

use App\Repository\PieceModeleRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

#[ORM\Entity(repositoryClass: PieceModeleRepository::class)]
#[ORM\Table(name: "piece_modele")]
class PieceModele
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column(name:"id")]
    private ?int $id = null;

    #[ORM\Column(name: "piece_version", length: 250)]
    private ?string $pieceVersion = null;

    #[ORM\Column(name: "piece_valeur")]
    #[Assert\Positive(message: "La valeur de la pièce doit être positive.")]
    private ?int $pieceValeur = null;

    #[ORM\Column(name: "piece_date_frappee",type: Types::DATE_MUTABLE)]
    private ?\DateTimeInterface $pieceDateFrappee = null;

    #[ORM\Column(name: "piece_quantite_frappee",type: Types::BIGINT)]
    private ?string $pieceQuantiteFrappee = null;

    #[ORM\OneToMany(targetEntity: PiecePays::class, mappedBy: 'pieceModeleID', cascade: ['remove'])]
    private Collection $piecePays;

    #[ORM\OneToMany(targetEntity: PieceTranche::class, mappedBy: 'pieceModeleID', cascade: ['remove'])]
    private Collection $pieceTranches;

    #[ORM\OneToMany(targetEntity: PieceCaracteristique::class, mappedBy: 'pieceModeleID', cascade: ['remove'])]
    private Collection $pieceCaracteristiques;

    #[ORM\OneToMany(targetEntity: Collectionner::class, mappedBy: 'pieceModeleID', cascade: ['remove'])]
    private Collection $collectionners;


    public function __construct()
    {
        $this->piecePays = new ArrayCollection();
        $this->pieceTranches = new ArrayCollection();
        $this->pieceCaracteristiques = new ArrayCollection();
        $this->collectionners = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getPieceVersion(): ?string
    {
        return $this->pieceVersion;
    }

    public function setPieceVersion(string $pieceVersion): static
    {
        $this->pieceVersion = $pieceVersion;

        return $this;
    }

    public function getPieceValeur(): ?int
    {
        return $this->pieceValeur;
    }

    public function setPieceValeur(int $pieceValeur): static
    {
        $this->pieceValeur = $pieceValeur;

        return $this;
    }

    public function getPieceDateFrappee(): ?\DateTimeInterface
    {
        return $this->pieceDateFrappee;
    }

    public function setPieceDateFrappee(\DateTimeInterface $pieceDateFrappee): static
    {
        $this->pieceDateFrappee = $pieceDateFrappee;

        return $this;
    }

    public function getPieceQuantiteFrappee(): ?string
    {
        return $this->pieceQuantiteFrappee;
    }

    public function setPieceQuantiteFrappee(string $pieceQuantiteFrappee): static
    {
        $this->pieceQuantiteFrappee = $pieceQuantiteFrappee;

        return $this;
    }

    /**
     * @return Collection<int, PiecePays>
     */
    public function getPiecePays(): Collection
    {
        return $this->piecePays;
    }

    public function addPiecePay(PiecePays $piecePay): static
    {
        if (!$this->piecePays->contains($piecePay)) {
            $this->piecePays->add($piecePay);
            $piecePay->setPieceModeleID($this);
        }

        return $this;
    }

    public function removePiecePay(PiecePays $piecePay): static
    {
        if ($this->piecePays->removeElement($piecePay)) {
            // set the owning side to null (unless already changed)
            if ($piecePay->getPieceModeleID() === $this) {
                $piecePay->setPieceModeleID(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, PieceTranche>
     */
    public function getPieceTranches(): Collection
    {
        return $this->pieceTranches;
    }

    public function addPieceTranch(PieceTranche $pieceTranch): static
    {
        if (!$this->pieceTranches->contains($pieceTranch)) {
            $this->pieceTranches->add($pieceTranch);
            $pieceTranch->setPieceModeleID($this);
        }

        return $this;
    }

    public function removePieceTranch(PieceTranche $pieceTranch): static
    {
        if ($this->pieceTranches->removeElement($pieceTranch)) {
            // set the owning side to null (unless already changed)
            if ($pieceTranch->getPieceModeleID() === $this) {
                $pieceTranch->setPieceModeleID(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, PieceCaracteristique>
     */
    public function getPieceCaracteristiques(): Collection
    {
        return $this->pieceCaracteristiques;
    }

    public function addPieceCaracteristique(PieceCaracteristique $pieceCaracteristique): static
    {
        if (!$this->pieceCaracteristiques->contains($pieceCaracteristique)) {
            $this->pieceCaracteristiques->add($pieceCaracteristique);
            $pieceCaracteristique->setPieceModeleID($this);
        }

        return $this;
    }

    public function removePieceCaracteristique(PieceCaracteristique $pieceCaracteristique): static
    {
        if ($this->pieceCaracteristiques->removeElement($pieceCaracteristique)) {
            // set the owning side to null (unless already changed)
            if ($pieceCaracteristique->getPieceModeleID() === $this) {
                $pieceCaracteristique->setPieceModeleID(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection<int, Collectionner>
     */
    public function getCollectionners(): Collection
    {
        return $this->collectionners;
    }

    public function addCollectionner(Collectionner $collectionner): static
    {
        if (!$this->collectionners->contains($collectionner)) {
            $this->collectionners->add($collectionner);
            $collectionner->setPieceModeleID($this);
        }

        return $this;
    }

    public function removeCollectionner(Collectionner $collectionner): static
    {
        if ($this->collectionners->removeElement($collectionner)) {
            // set the owning side to null (unless already changed)
            if ($collectionner->getPieceModeleID() === $this) {
                $collectionner->setPieceModeleID(null);
            }
        }

        return $this;
    }
}
