<?php

namespace App\Entity;

use App\Repository\PieceCaracteristiqueRepository;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

#[ORM\Entity(repositoryClass: PieceCaracteristiqueRepository::class)]
#[ORM\Table(name: "piece_caracteristique")]
class PieceCaracteristique
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column(name: "id")]
    private ?int $id = null;

    #[ORM\ManyToOne(inversedBy: 'pieceCaracteristiques')]
    #[ORM\JoinColumn(name:"piece_modele_id_id", nullable: false)]
    private ?PieceModele $pieceModeleID = null;

    #[ORM\Column(name: "piece_face_commune", length: 250)]
    private ?string $pieceFaceCommune = null;

    #[ORM\Column(name: "piece_masse")]
    #[Assert\Positive(message: "La masse de la pièce doit être positive.")]
    private ?int $pieceMasse = null;

    #[ORM\Column(name: "piece_taille")]
    #[Assert\Positive(message: "La taille de la pièce doit être positive.")]
    private ?int $pieceTaille = null;

    #[ORM\Column(name:"piece_materiau", length: 75)]
    private ?string $pieceMateriau = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getPieceModeleID(): ?PieceModele
    {
        return $this->pieceModeleID;
    }

    public function setPieceModeleID(?PieceModele $pieceModeleID): static
    {
        $this->pieceModeleID = $pieceModeleID;

        return $this;
    }

    public function getPieceFaceCommune(): ?string
    {
        return $this->pieceFaceCommune;
    }

    public function setPieceFaceCommune(string $pieceFaceCommune): static
    {
        $this->pieceFaceCommune = $pieceFaceCommune;

        return $this;
    }

    public function getPieceMasse(): ?int
    {
        return $this->pieceMasse;
    }

    public function setPieceMasse(int $pieceMasse): static
    {
        $this->pieceMasse = $pieceMasse;

        return $this;
    }

    public function getPieceTaille(): ?int
    {
        return $this->pieceTaille;
    }

    public function setPieceTaille(int $pieceTaille): static
    {
        $this->pieceTaille = $pieceTaille;

        return $this;
    }

    public function getPieceMateriau(): ?string
    {
        return $this->pieceMateriau;
    }

    public function setPieceMateriau(string $pieceMateriau): static
    {
        $this->pieceMateriau = $pieceMateriau;

        return $this;
    }
}
