<?php

namespace App\Entity;

use App\Repository\CollectionneurRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: CollectionneurRepository::class)]
#[ORM\Table(name: "collectionneur")]
class Collectionneur
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column(name:"id")]
    private ?int $id = null;

    #[ORM\Column(name:"collectionneur_nom", length: 250)]
    private ?string $collectionneurNom = null;

    #[ORM\Column(name:"collectionneur_prenom", length: 250)]
    private ?string $collectionneurPrenom = null;

    #[ORM\OneToMany(targetEntity: Collectionner::class, mappedBy: 'collectionneurID', cascade: ['remove'])]
    private Collection $collectionners;

    public function __construct()
    {
        $this->collectionners = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getCollectionneurNom(): ?string
    {
        return $this->collectionneurNom;
    }

    public function setCollectionneurNom(string $collectionneurNom): static
    {
        $this->collectionneurNom = $collectionneurNom;

        return $this;
    }

    public function getCollectionneurPrenom(): ?string
    {
        return $this->collectionneurPrenom;
    }

    public function setCollectionneurPrenom(string $collectionneurPrenom): static
    {
        $this->collectionneurPrenom = $collectionneurPrenom;

        return $this;
    }

    /**
     * @return Collection<int, Collectionner>
     */
    public function getCollectionners(): Collection
    {
        return $this->collectionners;
    }

    public function addCollectionner(Collectionner $collectionner): static
    {
        if (!$this->collectionners->contains($collectionner)) {
            $this->collectionners->add($collectionner);
            $collectionner->setCollectionneurID($this);
        }

        return $this;
    }

    public function removeCollectionner(Collectionner $collectionner): static
    {
        if ($this->collectionners->removeElement($collectionner)) {
            // set the owning side to null (unless already changed)
            if ($collectionner->getCollectionneurID() === $this) {
                $collectionner->setCollectionneurID(null);
            }
        }

        return $this;
    }
}
