<?php

namespace App\Controller;

use App\Entity\PieceTranche;
use App\Form\PieceTrancheType;
use App\Repository\PieceTrancheRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route('/pieceTranche')]
class PieceTrancheController extends AbstractController
{
    #[Route('/', name: 'app_piece_tranche_index', methods: ['GET'])]
    public function index(PieceTrancheRepository $pieceTrancheRepository): Response
    {
        return $this->render('piece_tranche/index.html.twig', [
            'piece_tranches' => $pieceTrancheRepository->findBy([], ['id' => 'ASC'] ),
        ]);
    }

    #[Route('/insert', name: 'app_piece_tranche_new', methods: ['GET', 'POST'])]
    public function insert(Request $request, EntityManagerInterface $entityManager): Response
    {
        $pieceTranche = new PieceTranche();
        $form = $this->createForm(PieceTrancheType::class, $pieceTranche);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->persist($pieceTranche);
            $entityManager->flush();

            return $this->redirectToRoute('app_piece_tranche_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('piece_tranche/new.html.twig', [
            'piece_tranche' => $pieceTranche,
            'form' => $form,
        ]);
    }

    #[Route('/{id}', name: 'app_piece_tranche_show', methods: ['GET'])]
    public function show(PieceTranche $pieceTranche): Response
    {
        return $this->render('piece_tranche/show.html.twig', [
            'piece_tranche' => $pieceTranche,
        ]);
    }

    #[Route('/update/{id}/', name: 'app_piece_tranche_edit', methods: ['GET', 'POST'])]
    public function update(Request $request, PieceTranche $pieceTranche, EntityManagerInterface $entityManager): Response
    {
        $form = $this->createForm(PieceTrancheType::class, $pieceTranche);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->flush();

            return $this->redirectToRoute('app_piece_tranche_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('piece_tranche/edit.html.twig', [
            'piece_tranche' => $pieceTranche,
            'form' => $form,
        ]);
    }

    #[Route('/delete/{id}', name: 'app_piece_tranche_delete', methods: ['GET','POST'])]
    public function delete(Request $request, PieceTranche $pieceTranche, EntityManagerInterface $entityManager): Response
    {
        if ($this->isCsrfTokenValid('delete'.$pieceTranche->getId(), $request->request->get('_token'))) {
            $entityManager->remove($pieceTranche);
            $entityManager->flush();
        }

        return $this->redirectToRoute('app_piece_tranche_index', [], Response::HTTP_SEE_OTHER);
    }
}
