package me.yoann.tp3.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.function.Function;

import org.graphstream.graph.Graph;
import org.graphstream.stream.file.FileSource;

/**
 * Classe permettant d'intéragir avec des fichiers en entrée et sorties.
 * 
 * @author Yoann Eichelberger
 *         M1 - IWOCS
 */
public final class IOUtils {
    
    private IOUtils() {}

    public static void readFile(String fileName, Graph graph, FileSource source) {
        try (InputStream stream = IOUtils.class.getClassLoader().getResourceAsStream(fileName)) {
            source.addSink(graph);
            source.readAll(stream);
        } catch(IOException ex) {
            ex.printStackTrace();
        } finally {
            source.removeSink(graph);
        }
    }

    public static void writeDistribution(String fileName, int[] dd, Function<Integer, Double> normalize) {
        try (FileWriter writer = new FileWriter(new File(fileName))) {
            for (int i = 0; i < dd.length; i++)
                if (dd[i] > 0)
                    writer.write(String.format(Locale.US, "%6d%20.8f%n", i, normalize.apply(dd[i])));
            writer.flush();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}