package ai.metaheuristic.genetic;

/**
 * @author Yoann Eichelberger - M1 IWOCS
 */
public abstract class Individual implements Comparable<Individual> {

    /**
     * @return longueur du génome.
     */
    public abstract int length();

    /**
     * @return la score de l'individu entre 0 et 1.
     */
    public abstract double fitness();

    /**
     * Compare la fitness de deux individus.
     * 
     * @param o autre individu quelconque.
     * @return {@inheritdoc}
     */
    @Override
    public final int compareTo(Individual o) {
        return Double.compare(o.fitness(), fitness());
    }
}