package ai.metaheuristic.genetic.selector;

import ai.metaheuristic.genetic.Individual;

/**
 * @author Yoann Eichelberger - M1 IWOCS
 */
public interface SelectionOperator<I extends Individual> {

    /**
     * Pré-traitement à {@link #random}. Prépare l'opérateur de selection à tirer un
     * individu sur une population.
     * 
     * @param population la population à traiter.
     */
    void compute(I[] population);

    /**
     * Post-traitement à {@link compute}. Tire un individu plus ou moins
     * aléatoirement (Dépend de l'implémentation).
     * 
     * @return un individu aléatoire.
     */
    I random();
}
