package ai.metaheuristic.genetic.selector;

import ai.metaheuristic.genetic.Individual;

/**
 * @author Yoann Eichelberger - M1 IWOCS
 */
public class DuelOperator<I extends Individual> implements SelectionOperator<I> {

    private I[] population;

    /**
     * Stocke en mémoire la population.
     */
    @Override
    public void compute(I[] population) {
        this.population = population;
    }

    /**
     * Tire deux individu d'une population pour ne renvoyer que celui ayant la
     * meilleur fitness.
     * 
     * @return le meilleur individu sur un couple aléatoire.
     */
    @Override
    public I random() {
        int n = this.population.length;
        int a = (int) (Math.floor(Math.random() * n));
        int b = (int) (a + 1 + Math.floor(Math.random() * n)) % n;
        I ia = this.population[a];
        I ib = this.population[b];
        double fa = ia.fitness();
        double fb = ib.fitness();
        return fa > fb ? ia : fa < fb ? ib : Math.random() < .5 ? ia : ib;
    }
}