package ai;

import ai.queens.QueenResolver;

/**
 * @author Yoann Eichelberger - M1 IWOCS
 */
public class App {

    /**
     * Lance le programme.
     */
    public static void main(String[] args) {
        int min = args.length > 0 ? Integer.parseInt(args[0]) : 4;
        int max = args.length > 1 ? Integer.parseInt(args[1]) : args.length == 1 ? min + 1 : 100;
        long begin, end;
        for (int i = min; i < max; i++) {
            Resolver<int[]> resolver = new QueenResolver(i);
            begin = System.currentTimeMillis();
            int[] solution = resolver.search();
            end = System.currentTimeMillis();
            show(solution);
            System.out.printf("i: %d time: %dms%n", i, (end - begin));
        }
    }

    /**
     * Affiche la solution à l'utilisateur.
     * 
     * @param queens
     */
    public static void show(int[] queens) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < queens.length; i++) {
            for (int j = 0; j < queens.length; j++) {
                sb.append(j == queens[i] ? "X" : " ");
                sb.append('|');
            }
            sb.append('\n');
        }
        sb.append('\n');
        System.out.println(sb.toString());
    }
}
