/**
 * PaiementScreen.tsx
 * @author Mattias EYHERABIDE
 */

import { StripeProvider, useStripe } from "@stripe/stripe-react-native";
import React, { useEffect, useState } from "react";

import { Alert, Text, Button, SafeAreaView} from "react-native";

/**
 * Page de l'application permettant de réaliser le paiement à l'aide de l'API de Stripe.
 * @param navigation
 * @param route
 * @constructor
 */
export default function CheckoutScreen({navigation, route}: any)
{
    const STRIPE_PUBLIC_KEY = "pk_test_51MBbgTDF9sE7SkBRRrGV18ey2SbpYeyAWsuGo90IOXDl3iIgNWusvXkvW3sACYJ3mvfEswj34zSozGp0aI7aCyHc00lye4M9nC";
    const LOCAL_API_ADRESS = "http://172.26.2.198:8000";

    const { initPaymentSheet, presentPaymentSheet } = useStripe();
    const [loading, setLoading] = useState(false);
    const [paymentIntentId, setPaymentIntentId] = useState<string>("");

    const userId = 1;
    const itemsId = [1];

    const { panier } = route.params;

    if ( panier.length == 0 )
    {
        alert("Panier vide !");
        navigation.goBack();
    }

    const amount = panier.reduce((sum: number, item: {id: string, name: string, price: number, inCart:number}) => {
        return sum + (item.price * item.inCart);
    }, 0);

    const fetchPaymentSheetParams = async () => {
        const response = await fetch(`${LOCAL_API_ADRESS}/payments/`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({
                "amount": amount,
                "customer_id": userId
            })
        });

        const { paymentIntent, ephemeralKey, customer } = await response.json();

        return {
            paymentIntent,
            ephemeralKey,
            customer,
        };
    };

    const initializePaymentSheet = async () => {
        const {
            paymentIntent,
            ephemeralKey,
            customer,
        } = await fetchPaymentSheetParams();

        const { error } = await initPaymentSheet({
            merchantDisplayName: "Example, Inc.",
            customerId: customer,
            customerEphemeralKeySecret: ephemeralKey,
            paymentIntentClientSecret: paymentIntent,
            allowsDelayedPaymentMethods: false,
        });

        if (!error) {
            setPaymentIntentId(paymentIntent);
            setLoading(true);
        }
    };

    const openPaymentSheet = async () => {
        const { error } = await presentPaymentSheet();

        if (error) {
            Alert.alert(`Error code: ${error.message}`, error.message);
        } else {
            const paymentIntent = `pi_${paymentIntentId.split("_")[1]}`;
            const response = await fetch(`${LOCAL_API_ADRESS}/payments/check/${paymentIntent}`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    "items_id": itemsId,
                    "customer_id": userId
                })
            });

            if (response.status == 200) Alert.alert('Succès', 'Votre commande est confirmée');
        }
    };

    useEffect(() => {
        initializePaymentSheet();
    }, []);

    return (
        <SafeAreaView>
            <StripeProvider
                publishableKey={STRIPE_PUBLIC_KEY}
                merchantIdentifier="mattias.eyherabide@etu.univ-lehavre.fr">
                <Text>{amount / 100}</Text>
                <Button
                    disabled={!loading}
                    title="Checkout"
                    onPress={openPaymentSheet}
                />
            </StripeProvider>
        </SafeAreaView>
    );
}