/**
 * AccueilScreen.tsx
 * @author Mattias EYHERABIDE
 */

import React, { useEffect, useState } from "react";
import { Alert, Text, Button, SafeAreaView, View, StyleSheet, FlatList, TouchableOpacity, PlatformColor }
    from "react-native";

import { useIsFocused } from "@react-navigation/native";
import * as SecureStore from 'expo-secure-store';

/**
 * Ecran d'accueil de l'application permettant d'aller sur les différentes routes.
 * @param route
 * @param navigation
 * @constructor
 */
export default function AccueilScreen({route, navigation}: any)
{

    const [cart, setCart] = useState([]);
    const isFocused = useIsFocused();

    useEffect(() => {
        const getPanier = async function()
        {
            const panier = await SecureStore.getItemAsync('panier');

            if ( panier != null ) { setCart( JSON.parse(panier) ); }
        }
        getPanier();
    }, [isFocused]);

    return (
        <SafeAreaView style={styles.container}>

            <TouchableOpacity style={styles.cartButton} onPress={() => navigation.navigate('shoppingCart')}>

                <View style={styles.cartTextView}>

                    <Text style={styles.cartText}> Panier </Text>

                </View>

            </TouchableOpacity>

            <TouchableOpacity style={styles.link} onPress={() => navigation.navigate("scanner")}>

                <Text> Ajouter des articles au panier </Text>

            </TouchableOpacity>

        </SafeAreaView>
    );
}

const styles = StyleSheet.create({
    container: {
        flex: 1,
        flexDirection: 'column',
        justifyContent: 'flex-start',
    },
    cartButton: {
        display: 'flex',
        justifyContent: 'flex-end',
        alignItems: 'flex-end',
        padding: 20,
    },
    link: {
        display: 'flex',
        flexDirection: 'row',
        justifyContent: 'center',
        alignItems: 'center',
        padding: 10,
    },

    cartTextView: {
        position: 'absolute',
        top: 5,
        left: 5,
        backgroundColor: 'black',
        borderRadius: 20,
        width: 80,
        height: 20,
        display: 'flex',
        justifyContent: 'center',
        alignItems: 'center',
    },
    cartText: {
        color: 'white',
        fontSize: 12,
    }
});