/**
 * App.tsx
 * @author Mattias EYHERABIDE
 */

import { NavigationContainer } from '@react-navigation/native';
import { createNativeStackNavigator } from '@react-navigation/native-stack';

import AccueilScreen from './screens/AccueilScreen';
import PaiementScreen from './screens/PaiementScreen';

const Stack = createNativeStackNavigator();

/**
 * Fichier Racine du projet App.
 * @constructor
 */
export default function App() {
  return (
      <NavigationContainer>
        <Stack.Navigator>
          <Stack.Screen name="navigation" component={AccueilScreen} />
          <Stack.Screen name="checkout" component={PaiementScreen} />
        </Stack.Navigator>
      </NavigationContainer>
  );
}
