<?php

/**
 * Class VueQuantite
 */
class VueQuantite
{

    /**
     * production d'une string contenant un tableau HTML qui represente la table quantité
     * @param quantite 
     * @return string
     */
    public function getHTML4Quantite(Quantite $quantite): string
    {
        $ch = "<table border='1'>
        <tr><th>id_quantite</th><th>nom_quantite</th><th>categorie_quantite</th></tr><tr>\n";
        $ch .= "<tr><td>" . $quantite->getNom_bouteille() . "</td>\n";
        $ch .= "<td>" . $quantite->getVolume_bouteille() . "</td>\n";
        $ch .= "<td>" . $quantite->getMillesime_bouteille() . "</td>\n";
        $ch .= "<td>" . $quantite->getQte_bouteille() . "</td>\n";
        $ch.= "</tr></table>\n";
        return $ch;
    }

    /**
     * production d'une string contenant un formulaire HTML
     * destiné à saisir une nouvelle quantite ou a en modifier une
     * @param array $assoc
     * @return string
     */
    public function getFormulaire4Quantite(array $assoc): string
    {
        $ch = "<form action='".$_SERVER['PHP_SELF']."' method='GET'>\n";
        foreach ($assoc as $col => $val) {
            if($col == "qte_bouteille"){
                if (is_array($val)) {
                    $ch .= "$col : <input name='$col' type='".$val['type']
                        ."' value='".$val['default']."' />\n";
                }
                else
                    $ch .= "$col : <input type='$val' name='$col' />\n";
            }
            else{
                if (is_array($val)) {
                    $ch .= "$col : <input name='$col' type='".$val['type']
                        ."' value='".$val['default']."' disabled />\n";
                }
                else
                    $ch .= "$col : <input type='$val' name='$col' disabled />\n";
                $ch.= "<input type='hidden' name='$col' value='".$val['default']."'/>";
            }
            
        }
        $ch .= "<input type='submit' name='Valider' value='Sauver'/>\n";


        return $ch."</form>\n";
    }

    /**
     * production d'une string contenant une liste HTML représentant un ensemble de livres
     * et permettant de les modifier ou de les supprimer grace à un lien hypertexte
     * @param quantite $tabEntitequantite un tableau d'instances d'EntiteLivre
     * @return string
     */
    public function getAllQuantite(array $tabEntitequantite): string
    {
        $ch = "<table>\n<tr><th>nom_bouteille</th><th>volume_bouteille</th>
         <th>millesime_bouteille</th><th>qte_bouteille</th><th>Modification</th><th>Suppression</th></tr>";
        foreach ($tabEntitequantite as $quantite) {
            $ch.= "<tr>";
            if ($quantite instanceof Quantite) {
                $ch .= "<td>".$quantite->getNom_bouteille()."</td>";
                $ch .= "<td>".$quantite->getVolume_bouteille()."</td>";
                $ch .= "<td>".$quantite->getMillesime_bouteille()."</td>";
                $ch .= "<td>".$quantite->getQte_bouteille()."</td>";
                $ch .= "<td><a href='?action=update&nom_bouteille=".$quantite->getNom_bouteille()."&volume_bouteille=".$quantite->getVolume_bouteille()."&millesime_bouteille=".$quantite->getMillesime_bouteille()."'>Modifier</a></td> ";
                $ch .= "<td><a href='?action=delete&nom_bouteille=".$quantite->getNom_bouteille()."&volume_bouteille=".$quantite->getVolume_bouteille()."&millesime_bouteille=".$quantite->getMillesime_bouteille()."'>Supprimer</a></td> ";
            }

            $ch.= "</tr>";
        }
        return $ch."</table>\n";
    }

    public function getAllVolumes():string
    {
        $st ="";
        $choix = array(37.5,75,150,300,500,600,900,1200,1500,1800);
        for ($i=0; $i < 10; $i++) { 
            $st .= "<option>".$choix[$i]."</option>";
        }
        return $st;
    }


}

