<?php

/**
 * Class VueOenologue
 * @package lmsf
 */
class VueOenologue
{

    /**
     * production d'une string contenant un tableau HTML représentant un livre
     * @param Oenologue $livre
     * @return string
     */
    public function getHTML4Oeonologue(Oenologue $oenologue): string
    {
        $ch = "<table border='1'>
        <tr><th>id_oenologue</th><th>nom_oenologue</th></tr><tr>\n";
        $ch .= "<tr><td>" . $oenologue->getIdOenologue() . "</td>\n";
        $ch .= "<td>" . $oenologue->getNomOenologue() . "</td>\n";
        $ch.= "</tr></table>\n";
        return $ch;
    }

    /**
     * production d'une string contenant un formulaire HTML
     * destiné à saisir une nouveau livre ou à modifier un livre existant
     * @param array $assoc
     * @return string
     */
    public function getFormulaire4Oeonologue(array $assoc): string
    {
        $ch = "<form action='".$_SERVER['PHP_SELF']."' method='GET'>\n";
        foreach ($assoc as $col => $val) {
            if (is_array($val)) {
                $ch .= "$col : <input name='$col' type='".$val['type']
                    ."' value='".$val['default']."' />\n";
            }
            else
                $ch .= "$col : <input type='$val' name='$col' />\n";
        }
        $ch .= "<input type='submit' name='Valider' value='Sauver'/>\n";


        return $ch."</form>\n";
    }

    /**
     * production d'une string contenant une liste HTML représentant un ensemble de livres
     * et permettant de les modifier ou de les supprimer grace à un lien hypertexte
     * @param Oenologue $tabEntiteOenologue un tableau d'instances d'EntiteLivre
     * @return string
     */
    public function getAllOeonologue(array $tabEntiteOenologue): string
    {
        $ch = "<table>\n<tr><th>id_oenologue</th><th>nom_oenologue</th>
                            <th>Modification</th><th>Suppression</th></tr>";
        foreach ($tabEntiteOenologue as $oenologue) {
            $ch.= "<tr>";
            if ($oenologue instanceof Oenologue) {
                $ch .= "<td>".$oenologue->getIdOenologue()."</td>";
                $ch .= "<td>".$oenologue->getNomOenologue()."</td>";
                $ch .= "<td> <a href='?action=update&id_oenologue=".$oenologue->getIdOenologue()."'>Modifier</a></td> ";
                $ch .= "<td> <a href='?action=delete&id_oenologue=".$oenologue->getIdOenologue()."'>Supprimer</a></td> ";
            }
            $ch.= "</tr>";
        }
        return $ch."</table>\n";
    }


}

