<?php

require_once("../Tables/Degustation.php");

/**
 * Class VueCategorie
 * @package lmsf
 */
class VueDegustation
{

    /**
     * production d'une string contenant un tableau HTML représentant une degustation
     * @param Degustation $degustation
     * @return string
     */
    public function getHTML4Degustation(Degustation $degustation): string
    {
        $ch = "<table border='1'>
        <tr><th>id_degustation</th><th>note_degustation</th><th>date_degustation</th><th>id_bouteille</th><th>id_oenologue</th></tr><tr>\n";
        $ch .= "<tr><td>" . $degustation->getId_degustation() . "</td>\n";
        $ch .= "<td>" . $degustation->getNote_degustation() . "</td>\n";
        $ch .= "<td>" . $degustation->getDate_degustation() . "</td>\n";
        $ch .= "<td>" . $degustation->getId_bouteille() . "</td>\n";
        $ch .= "<td>" . $degustation->getId_oenologue() . "</td>\n";
        $ch.= "</tr></table>\n";
        return $ch;
    }

    /**
     * production d'une string contenant un formulaire HTML
     * destiné à saisir une nouvelle catégorie ou à modifier une catégorie existant
     * @param array $assoc
     * @return string
     */
    public function getFormulaire4Degustation(array $assoc): string
    {
        $ch = "<form action='".$_SERVER['PHP_SELF']."' method='GET'>\n";
        foreach ($assoc as $col => $val) {
            if (is_array($val)) {
                $ch .= "$col : <input name='$col' type='".$val['type']
                    ."' value='".$val['default']."' />\n";
            }
            else
                $ch .= "$col : <input type='$val' name='$col' />\n";
        }
        $ch .= "<input type='submit' name='Valider' value='Sauver'/>\n";


        return $ch."</form>\n";
    }

    /**
     * production d'une string contenant une liste HTML représentant un ensemble de catégories
     * et permettant de les modifier ou de les supprimer grace à un lien hypertexte
     * @param Degustation $tabDegustation un tableau d'instances de catégories
     * @return string
     */
    public function getAllDegustation(array $tabDegustation): string
    {
        $ch = "<table>\n<tr><th>id_degustation</th><th>note_degustation</th><th>date_degustation</th>
                <th>id_bouteille</th><th>id_oenologue</th><th>Modification</th><th>Suppression</th></tr>";
        foreach ($tabDegustation as $degustation) {
            $ch.= "<tr>";
            if ($degustation instanceof Degustation) {
                $ch .= "<td>".$degustation->getId_degustation()."</td>";
                $ch .= "<td>".$degustation->getNote_degustation()."</td>";
                $ch .= "<td>".$degustation->getDate_degustation()."</td>";
                $ch .= "<td>".$degustation->getId_bouteille()."</td>";
                $ch .= "<td>".$degustation->getId_oenologue()."</td>";
                $ch .= "<td> <a href='?action=update&id_categorie=".$degustation->getId_degustation()."'>Modifier</a></td>";
                $ch .= "<td> <a href='?action=delete&id_categorie=".$degustation->getId_degustation()."'>Supprimer</a></td>";
            }
            $ch.= "</tr>";
        }
        return $ch."</table>\n";
    }
}

?>