<?php

class VueCategorie
{

/**
  * production d'une string contenant un tableau HTML représentant une Categorie
  * @param Categorie $Categorie
  * @return string
  */
    public function getHTML4Categorie(Categorie $Categorie): string
    {
        $ch = "<table border='1'>
        <tr><th>id_Categorie</th>
            <th>volume_Categorie</th>
            <th>prix_Categorie</th>
            <th>id_appellation</th></tr>\n";
        $ch .= "<tr><td>" . $Categorie->getId_Categorie() . "</td>\n";
        $ch .= "<td>" . $Categorie->getRobe_bouteille() . "</td>\n";
        $ch .= "<td>" . $Categorie->getSucrage_bouteille() . "</td>\n";
        $ch .= "<td>" . $Categorie->getType_bouteille() . "</td>\n";
        $ch.= "</tr></table>\n";
        return $ch;
    }

    /**
     * production d'une string contenant un formulaire HTML 
     * destiné à saisir une nouvelle Categorie ou à modifier une Categorie existante
     * @param array $assoc
     * @return string
        */
    public function getFormulaire4Categorie(array $assoc): string
    {
        $ch = "<form action='".$_SERVER['PHP_SELF']."' method='GET'>\n";
        foreach ($assoc as $col => $val) {
            if (is_array($val)) {
                if($col == "id_categorie")
                {
                    $ch .= "$col : <input name='$col' type='".$val['type']
                                  ."' value='".$val['default']."' step='any' disabled/>\n";
                    $ch.= "<input type='hidden' name='$col' value='".$val['default']."'/>";
                }
                else if($col == "robe_bouteille")
                    $ch .= "$col : <select name ='$col' >".$this->getAllRobes($val['default'])."</select>";
                else if($col == "sucrage_bouteille")
                    $ch .= "$col : <select name ='$col' >".$this->getAllSucrages($val['default'])."</select>";
                else if($col == "type_bouteille")
                    $ch .= "$col : <select name ='$col' >".$this->getAllTypes($val['default'])."</select>";
                else{
                    $ch .= "$col : <input name='$col' type='".$val['type']
                    ."' value='".$val['default']."' />\n";
                }   
            }
            else{
                if($col == "robe_bouteille")
                    $ch .= "$col : <select name ='$col' >".$this->getAllRobes()."</select>";
                else if($col == "sucrage_bouteille")
                    $ch .= "$col : <select name ='$col' >".$this->getAllSucrages()."</select>";
                else if($col == "type_bouteille")
                    $ch .= "$col : <select name ='$col' >".$this->getAllTypes()."</select>";
                else
                    $ch .= "$col : <input type='$val' name='$col' />\n";
            } 
        }
        $ch .= "<input type='submit' name='Valider' value='Sauver'/>\n";


        return $ch."</form>\n";
    }

/**
     * production d'une string contenant une liste HTML représentant un ensemble de Categories
     * et permettant de les modifier ou de les supprimer grace à un lien hypertexte
     * @param Categorie $tabCategorie un tableau d'instances de Categories
     * @return string
        */
    public function getAllCategorie(array $tabCategorie): string
    {
        $ch = "<table>\n<tr><th>id_categorie</th><th>robe_bouteille</th><th>sucrage_bouteille</th>
                <th>type_bouteille</th><th>Modification</th><th>Suppression</th></tr>";
        foreach ($tabCategorie as $categorie) {
            $ch.= "<tr>";
            if ($categorie instanceof Categorie) {
                $ch .= "<td>".$categorie->getId_categorie()."</td>";
                $ch .= "<td>".$categorie->getRobe_bouteille()."</td>";
                $ch .= "<td>".$categorie->getSucrage_bouteille()."</td>";
                $ch .= "<td>".$categorie->getType_bouteille()."</td>";
                $ch .= "<td><a href='?action=update&id_categorie=".$categorie->getId_categorie()."'>Modifier</a></td>";
                $ch .= "<td><a href='?action=delete&id_categorie=".$categorie->getId_categorie()."'>Supprimer</a></td>";
            }
            $ch.= "</tr>";
        }
        return $ch."</table>\n";
    }

    public function getAllRobes(string $s = "Rouge"):string
    {
        $st ="";
        $choix = array("Rouge","Blanc","Rosé");
        for ($i=0; $i < 3; $i++) { 
            if($s == $choix[$i]){$st .= "<option selected>".$choix[$i]."</option>";}
            else {$st .="<option>".$choix[$i]."</option>";}
        }
        return $st;
    }

    public function getAllSucrages(string $s = "Sec"):string
    {
        $st ="";
        $choix = array("Sec","Demi-sec","Moelleux","Liquoreux");
        for ($i=0; $i < 4; $i++) { 
            if($s == $choix[$i]){$st .= "<option selected>".$choix[$i]."</option>";}
            else {$st .="<option>".$choix[$i]."</option>";}
        }
        return $st;
    }

    public function getAllTypes(string $s = "Vin tranquille"):string
    {
        $st ="";
        $choix = array("Vin tranquille","Vin effervescent","Vin doux naturel","Vin cuit");
        for ($i=0; $i < 4; $i++) { 
            if($s == $choix[$i]){$st .= "<option selected>".$choix[$i]."</option>";}
            else {$st .="<option>".$choix[$i]."</option>";}
        }
        return $st;
    }
}

?>