<?php

class VueBouteille
{

/**
  * production d'une string contenant un tableau HTML représentant une bouteille
  * @param Bouteille $bouteille
  * @return string
  */
    public function getHTML4Bouteille(Bouteille $bouteille): string
    {
        $ch = "<table border='1'>
        <tr><th>id_bouteille</th><th>nom_bouteille</th>
            <th>volume_bouteille</th><th>millesime_bouteille</th>
            <th>prix_bouteille</th><th>id_categorie</th>
            <th>id_appellation</th></tr><tr>\n";
        $ch .= "<tr><td>" . $bouteille->getId_Bouteille() . "</td>\n";
        $ch .= "<td>" . $bouteille->getNom_bouteille() . "</td>\n";
        $ch .= "<td>" . $bouteille->getVolume_bouteille() . "</td>\n";
        $ch .= "<td>" . $bouteille->getMillesime_bouteille() . "</td>\n";
        $ch .= "<td>" . $bouteille->getPrix_bouteille() . "</td>\n";
        $ch .= "<td>" . $bouteille->getId_categorie() . "</td>\n";
        $ch .= "<td>" . $bouteille->getId_appellation() . "</td>\n";
        $ch.= "</tr></table>\n";
        return $ch;
    }

    /**
     * production d'une string contenant un formulaire HTML 
     * destiné à saisir une nouvelle bouteille ou à modifier une bouteille existante
     * @param array $assoc
     * @return string
        */
    public function getFormulaire4Bouteille(array $assoc): string
    {
        $ch = "<form action='".$_SERVER['PHP_SELF']."' method='GET'>\n";
        foreach ($assoc as $col => $val) {
            if (is_array($val)) {
                if($col == "id_bouteille")
                {
                    $ch .= "$col : <input name='$col' type='".$val['type']
                                  ."' value='".$val['default']."' step='any' disabled/>\n";
                    $ch.= "<input type='hidden' name='$col' value='".$val['default']."'/>";
                }
                else if($col == "volume_bouteille")
                    $ch .= "$col : <select name ='$col' >".$this->getAllVolumes($val['default'])."</select>";
                else if($col == "id_categorie")
                    $ch .= "$col : <select name ='$col' >".$this->getAllIDCateg($val['default'])."</select>";
                else if($col == "id_appellation")
                    $ch .= "$col : <select name ='$col' >".$this->getAllIDAppellation($val['default'])."</select>";
                else
                {
                    $ch .= "$col : <input name='$col' type='".$val['type']
                                  ."' value='".$val['default']."' step='any' />\n";
                }
            }
            else
            {
                if($col == "volume_bouteille")
                    $ch .= "$col : <select name ='$col' >".$this->getAllVolumes()."</select>";
                else if($col == "id_categorie")
                    $ch .= "$col : <select name ='$col' >".$this->getAllIDCateg()."</select>";
                else if($col == "id_appellation")
                    $ch .= "$col : <select name ='$col' >".$this->getAllIDAppellation()."</select>";
                else
                    $ch .= "$col : <input type='$val' name='$col'/>\n";
            }
                
        }
        $ch .= "<input type='submit' name='Valider' value='Sauver'/>\n";


        return $ch."</form>\n";
    }

/**
     * production d'une string contenant une liste HTML représentant un ensemble de bouteilles
     * et permettant de les modifier ou de les supprimer grace à un lien hypertexte
     * @param Bouteille $tabBouteille un tableau d'instances de bouteilles
     * @return string
        */
    public function getAllBouteille(array $tabBouteille): string
    {
        $ch = "<table>\n<tr><th>id_bouteille</th><th>nom_bouteille</th><th>volume_bouteille</th>
                <th>millesime_bouteille</th><th>prix_bouteille</th><th>id_categorie</th><th>id_appellation</th>
                <th>Modification</th><th>Suppression</th></tr>";
        foreach ($tabBouteille as $bouteille) {
            $ch.= "<tr>";
            if ($bouteille instanceof Bouteille) {
                $ch .= "<td>".$bouteille->getId_Bouteille()."</td>";
                $ch .= "<td>".$bouteille->getNom_bouteille()."</td>";
                $ch .= "<td>".$bouteille->getVolume_bouteille()."</td>";
                $ch .= "<td>".$bouteille->getMillesime_bouteille()."</td>";
                $ch .= "<td>".$bouteille->getPrix_bouteille()."</td>";
                $ch .= "<td>".$bouteille->getId_categorie()."</td>";
                $ch .= "<td>".$bouteille->getId_appellation()."</td>";
                $ch .= "<td><a href='?action=update&id_bouteille=".$bouteille->getId_Bouteille()."'>Modifier</a></td>";
                $ch .= "<td><a href='?action=delete&id_bouteille=".$bouteille->getId_Bouteille()."'>Supprimer</a></td>";
            }
            $ch.= "</tr>";
        }
        return $ch."</table>\n";
    }

    public function getAllVolumes(string $s = "37.5"):string
    {
        $st ="";
        $choix = array("37.5", "75", "150", "300", "500", "600", "900", "1200", "1500", "1800");
        for ($i=0; $i < 10; $i++) { 
            if($s == $choix[$i]){$st .= "<option selected>".$choix[$i]."</option>";}
            else {$st .="<option>".$choix[$i]."</option>";}
        }
        return $st;
    }

    public function getAllIDCateg(string $s = ""):string
    {
        $st ="";

        $choix = array();

        $iterator = new CategorieIterator();
        foreach ($iterator as $id)
            array_push($choix, $id->getId_categorie());

        for ($i=0; $i < sizeof($choix); $i++) { 
            if($s == $choix[$i]){$st .= "<option selected>".$choix[$i]."</option>";}
            else {$st .="<option>".$choix[$i]."</option>";}
        }
        return $st;
    }

    public function getAllIDAppellation(string $s = ""):string
    {
        $st ="";

        $choix = array();

        $iterator = new AppellationIterator();
        foreach ($iterator as $id)
            array_push($choix, $id->getIdAppellation());

        for ($i=0; $i < sizeof($choix); $i++) { 
            if($s == $choix[$i]){$st .= "<option selected>".$choix[$i]."</option>";}
            else {$st .="<option>".$choix[$i]."</option>";}
        }
        return $st;
    }
}

?>