<?php

/**
 * Class VueAppellation
 */
class VueAppellation
{

    /**
     * production d'une string contenant un tableau HTML représentant un livre
     * @param Appellation 
     * @return string
     */
    public function getHTML4Appellation(Appellation $Appellation): string
    {
        $ch = "<table border='1'>
        <tr><th>id_Appellation</th><th>nom_Appellation</th><th>categorie_Appellation</th></tr><tr>\n";
        $ch .= "<tr><td>" . $Appellation->getIdAppellation() . "</td>\n";
        $ch .= "<td>" . $Appellation->getNomAppellation() . "</td>\n";
        $ch .= "<td>" . $Appellation->getCategorieAppellation() . "</td>\n";
        $ch.= "</tr></table>\n";
        return $ch;
    }

    /**
     * production d'une string contenant un formulaire HTML
     * destiné à saisir une nouvelle Appellation ou a en modifier une
     * @param array $assoc
     * @return string
     */
    public function getFormulaire4Appellation(array $assoc): string
    {
        $ch = "<form action='".$_SERVER['PHP_SELF']."' method='GET'>\n";
        foreach ($assoc as $col => $val) {
            if (is_array($val)) {
                if($col == "id_Appellation")
                {
                    $ch .= "$col : <input name='$col' type='".$val['type']
                                  ."' value='".$val['default']."' step='any' disabled/>\n";
                    $ch.= "<input type='hidden' name='$col' value='".$val['default']."'/>";
                }
                else if($col == "categorie_Appellation")
                {
                    $ch .= "$col : <select name ='$col' >".$this->getAllCategories($val['default'])."</select>";
                }
                else{
                    $ch .= "$col : <input name='$col' type='".$val['type']
                    ."' value='".$val['default']."' />\n";
                }   
            }
            else{
                if($col == "categorie_Appellation")
                {
                    $ch .= "$col : <select name ='$col' >".$this->getAllCategories()."</select>";
                }
                else
                    $ch .= "$col : <input type='$val' name='$col' />\n";
            }
        }
        $ch .= "<input type='submit' name='Valider' value='Sauver'/>\n";


        return $ch."</form>\n";
    }

    /**
     * production d'une string contenant une liste HTML représentant un ensemble de livres
     * et permettant de les modifier ou de les supprimer grace à un lien hypertexte
     * @param Appellation $tabEntiteAppellation un tableau d'instances d'EntiteLivre
     * @return string
     */
    public function getAllAppellation(): string
    {
        $ch = "<table>\n<tr><th>id_appellation</th><th>nom_appellation</th><th>categorie_appellation</th>
                <th>Modification</th><th>Suppression</th></tr>";
        $itAppellation = new AppellationIterator();
        foreach ($itAppellation as $Appellation) {
            $ch.= "<tr>";
                $ch .= "<td>".$Appellation->getIdAppellation()."</td>";
                $ch .= "<td>".$Appellation->getNomAppellation()."</td>";
                $ch .= "<td>".$Appellation->getCategorieAppellation()."</td>";
                $ch .= "<td> <a href='?action=update&id_Appellation=".$Appellation->getIdAppellation()."'>Modifier</a> </td> ";
                $ch .= "<td> <a href='?action=delete&id_Appellation=".$Appellation->getIdAppellation()."'>Supprimer</a> </td>";
            $ch.= "</tr>";
        }
        return $ch."</table>\n";
    }

    public function getAllCategories(string $s = "VDQS"):string
    {
        $st ="";
        $choix = array("VDQS","AOC/AOP","Vin de table","IGP","Vin de pays");
        for ($i=0; $i < 5; $i++) { 
            if($s == $choix[$i]){$st .= "<option selected>".$choix[$i]."</option>";}
            else {$st .="<option>".$choix[$i]."</option>";}
        }
        return $st;
    }


}

