<?php

class Degustation
{

    /**
     * Identifiant de la degustation
     * @var int
     */
    protected $id_degustation;

    /**
     * Note de la degustation
     * @var int
     */
    protected $note_degustation;

    /**
     * Date de la degustation
     * @var string
     */
    protected $date_degustation;

    /**
     * Identifiant de la bouteille
     * @var int
     */
    protected $id_bouteille;

    /**
     * Identifiant de l'oenologue
     * @var int
     */
    protected $id_oenologue;

    /**
     * attribut interne pour différencier les nouveaux objets des objets créés côté applicatif de ceux issus du SGBD
     * @var bool
     */
    private $persistant = TRUE;

    /**
     * @return $this->id_degustation
     */
    public function getId_degustation(): int
    {
        return $this->id_degustation;
    }

    /**
     * @param $id_degustation
     */
    public function setId_degustation($id_degustation): Degustation
    {
        $this->id_degustation = $id_degustation;
        return $this;
    }

    /**
     * @return $this->note_degustation
     */
    public function getNote_degustation(): string
    {
        return $this->note_degustation;
    }

    /**
     * @param $note_degustation
     */
    public function setNote_degustation($note_degustation): Degustation
    {
        $this->note_degustation = $note_degustation;
        return $this;
    }

    /**
     * @return $this->date_degustation
     */
    public function getDate_degustation(): string
    {
        return $this->date_degustation;
    }

    /**
     * @param $date_degustation
     */
    public function setDate_degustation($date_degustation): Degustation
    {
        $this->date_degustation = $date_degustation;
        return $this;
    }

    /**
     * @return $this->id_bouteille
     */
    public function getId_bouteille(): string
    {
        return $this->id_bouteille;
    }

    /**
     * @param $id_bouteille
     */
    public function setId_bouteille($id_bouteille): Degustation
    {
        $this->id_bouteille = $id_bouteille;
        return $this;
    }

    /**
     * @return $this->id_oenologue
     */
    public function getId_oenologue(): string
    {
        return $this->id_oenologue;
    }

    /**
     * @param $id_oenologue
     */
    public function setId_oenologue($id_oenologue): Degustation
    {
        $this->id_bouteille = $id_oenologue;
        return $this;
    }

    /**
     * @return $this->nouveau
     */
    public function getPersistant(): bool
    {
        return $this->persistant;
    }

    /**
     * @param $nouveau
     */
    public function setPersistant($persistant): Degustation
    {
        $this->persistant = $persistant;
        return $this;
    }

    public function __toString()
    {
        return "object:Degustation (" . $this->id_degustation . ", " . $this->note_degustation . ",
                                        " . $this->date_degustation . ", " . $this->id_bouteille . "," . $this->id_oenologue . ")";
    }
}

