<?php

class Categorie
{

/**
     * numéro de la catégorie (identifiant dans la table Categorie)
     * @var int
     */ 
    protected $id_categorie;

    /**
     * robe de la bouteille
     * @var string
     */ 
    protected $robe_bouteille;

    /**
     * sucrage de la bouteille
     *   @var string
     */ 
    protected $sucrage_bouteille;

    /**
     * type de la bouteille
     *   @var string
     */ 
    protected $type_bouteille;

    /**
     * attribut interne pour différencier les nouveaux objets des objets créés côté applicatif de ceux issus du SGBD
     * @var bool
     */ 
    private $persistant = TRUE;

    /**
     * @return $this->id_categorie
     */ 
    public function getId_categorie() : int {
        return $this->id_categorie;
    }

    /**
     * @param $id_categorie
     */ 
    public function setId_categorie($id_categorie): Categorie {
        $this->id_categorie = $id_categorie;
        return $this;
    }

    /**
     * @return $this->robe_bouteille
     */ 
    public function getRobe_bouteille() : string {
        return $this->robe_bouteille;
    }

    /**
     * @param $robe_bouteille
     */ 
    public function setRobe_bouteille($robe_bouteille): Categorie {
        $this->robe_bouteille = $robe_bouteille;
        return $this;
    }

    /**
     * @return $this->sucrage_bouteille
     */ 
    public function getSucrage_bouteille() : string {
        return $this->sucrage_bouteille;
    }

    /**
     * @param $sucrage_bouteille
     */ 
    public function setSucrage_bouteille($sucrage_bouteille): Categorie {
        $this->sucrage_bouteille = $sucrage_bouteille;
        return $this;
    }

    /**
     * @return $this->type_bouteille
     */ 
    public function getType_bouteille() : string {
        return $this->type_bouteille;
    }

    /**
     * @param $type_bouteille
     */ 
    public function setType_bouteille($type_bouteille): Categorie {
        $this->type_bouteille = $type_bouteille;
        return $this;
    }

    /**
     * @return $this->nouveau
     */ 
    public function getPersistant() : bool {
        return $this->persistant;
    }

    /**
     * @param $nouveau
     */ 
    public function setPersistant($persistant): Categorie {
        $this->persistant=$persistant;
        return $this;
    }

    public function __toString()
    {
        return "object:Categorie (".$this->id_categorie.", ".$this->robe_bouteille.",
                                        ".$this->sucrage_bouteille.", ".$this->type_bouteille.")";
    }
}

?>