<?php

class Bouteille
{

/**
     * numéro de la bouteille (identifiant dans la table Bouteille)
     * @var int
     */ 
    protected $id_bouteille;

    /**
     * nom de la bouteille
     * @var string
     */ 
    protected $nom_bouteille;

    /**
     * volume de la bouteille
     *   @var string
     */ 
    protected $volume_bouteille;

    /**
     * millesime de la bouteille
     *   @var string
     */ 
    protected $millesime_bouteille;

    /**
     * prix de la bouteille
     *   @var string
     */ 
    protected $prix_bouteille;

    /**
     * numéro de catégorie de la bouteille
     *   @var string
     */ 
    protected $id_categorie;

    /**
     * numéro d'appellation la bouteille
     *   @var string
     */ 
    protected $id_appellation;

    /**
     * attribut interne pour différencier les nouveaux objets des objets créés côté applicatif de ceux issus du SGBD
     * @var bool
     */ 
    private $persistant = TRUE;

    /**
     * @return $this->id_Bouteille
     */ 
    public function getId_bouteille() : int {
        return $this->id_bouteille;
    }

    /**
     * @param $id_Bouteille
     */ 
    public function setId_bouteille($id_bouteille): Bouteille {
        $this->id_bouteille = $id_bouteille;
        return $this;
    }

    /**
     * @return $this->nom_bouteille
     */ 
    public function getNom_bouteille() : string {
        return $this->nom_bouteille;
    }

    /**
     * @param $nom_bouteille
     */ 
    public function setNom_bouteille($nom_bouteille): Bouteille {
        $this->nom_bouteille = $nom_bouteille;
        return $this;
    }

    /**
     * @return $this->volume_bouteille
     */ 
    public function getVolume_bouteille() : float {
        return $this->volume_bouteille;
    }

    /**
     * @param $volume_bouteille
     */ 
    public function setVolume_bouteille($volume_bouteille): Bouteille {
        $this->volume_bouteille = $volume_bouteille;
        return $this;
    }

    /**
     * @return $this->millesime_bouteille
     */ 
    public function getMillesime_bouteille() : int {
        return $this->millesime_bouteille;
    }

    /**
     * @param $millesime_bouteille
     */ 
    public function setMillesime_bouteille($millesime_bouteille): Bouteille {
        $this->millesime_bouteille = $millesime_bouteille;
        return $this;
    }

    /**
     * @return $this->prix_bouteille
     */ 
    public function getPrix_bouteille() : float {
        return $this->prix_bouteille;
    }

    /**
     * @param $prix_bouteille
     */ 
    public function setPrix_bouteille($prix_bouteille): Bouteille {
        $this->prix_bouteille = $prix_bouteille;
        return $this;
    }

    /**
     * @return $this->id_categorie
     */ 
    public function getId_categorie() : int {
        return $this->id_categorie;
    }

    /**
     * @param $id_categorie
     */ 
    public function setId_categorie($id_categorie): Bouteille {
        $this->id_categorie = $id_categorie;
        return $this;
    }

    /**
     * @return $this->id_appellation
     */ 
    public function getId_appellation() : int {
        return $this->id_appellation;
    }

    /**
     * @param $id_appellation
     */ 
    public function setId_appellation($id_appellation): Bouteille {
        $this->id_appellation = $id_appellation;
        return $this;
    }

    /**
     * @return $this->nouveau
     */ 
    public function getPersistant() : bool {
        return $this->persistant;
    }

    /**
     * @param $nouveau
     */ 
    public function setPersistant($persistant): Bouteille {
        $this->persistant=$persistant;
        return $this;
    }

    public function __toString()
    {
        return "object:Bouteille (".$this->id_bouteille.", ".$this->nom_bouteille.",
                                  ".$this->volume_bouteille.", ".$this->millesime_bouteille.",
                                  ".$this->prix_bouteille.", ".$this->id_categorie.",
                                  ".$this->id_appellation.")";
    }
}

?>