<?php
/**
 * @author Tristan RAHARD
 * @date Fevrier 2021
 */

require_once "includes.php";
session_start();

if (isset($_GET['reset'])) { //pratique pour réinitialiser à la main
    unset($_SESSION['etatControleur']);
    unset($_SESSION['CRUD']);
    unset($_SESSION['message']);
    unset($_SESSION['etat']);
}

if (empty($_SESSION)) { // initialisation des variables de session
    $_SESSION['etatControleur'] = 'Accueil';
    $_SESSION['CRUD'] = 'Bouteille';
}

$pageHTML ="<!doctype html>
    <html lang=\"fr\">
    <head>
    <meta charset=\"utf-8\">
    <title>Table bouteille</title>
    <link rel=\"stylesheet\" href=\"CSS/style.css\">
    </head>
    <body>";

// on réalise les actions correspondant à l'action en cours :
try {
    if (isset($_GET['actionControleur'])) {
        switch ($_GET['actionControleur']) {
            case 'Bouteille' :
                $_SESSION['CRUD'] ='CRUD/CRUD_Bouteille.php';
                $_SESSION['etatControleur'] = 'afficheTable';
                break;
            case 'Categorie':
                $_SESSION['CRUD'] ='CRUD/CRUD_Categorie.php';
                $_SESSION['etatControleur'] = 'afficheTable';
                break;
            case 'Appellation':
                $_SESSION['CRUD'] ='CRUD/CRUDAppellation.php';
                $_SESSION['etatControleur'] = 'afficheTable';
                break;
            case 'Quantite':
                $_SESSION['CRUD'] ='CRUD/CRUDQuantite.php';
                $_SESSION['etatControleur'] = 'afficheTable';
                break;
            case 'Oenologue':
                $_SESSION['CRUD'] ='CRUD/CRUDOenologue.php';
                $_SESSION['etatControleur'] = 'afficheTable';
                break;
            case 'Accueil':
                $_SESSION['etatControleur'] = 'Accueil';
                break;
            default:
                echo "fail";
                break;
        }
    }
} catch (PDOException $exception) {
    $_SESSION['etatControleur'] = 'bug';
    $_SESSION['message'] = $exception->__toString();
}

switch($_SESSION['etatControleur']) {
    case 'Accueil':
        $pageHTML .= 
            "<form actionControleur='?' method='GET'>
                <select name='actionControleur'>
                    <option value='Bouteille'>  Bouteille  </option>
                    <option value='Categorie'>  Categorie  </option>
                    <option value='Appellation'>Appellation</option>
                    <option value='Oenologue'>  Oenologue  </option>
                    <option value='Quantite'>   Quantite   </option>
                </select>
                <input type='submit' name='envoi' value='Go' />
            </form>";
        break;
    case 'afficheTable':
        include "./".$_SESSION['CRUD'];
        $pageHTML .= "<form actionControleur='?' method='GET'><input type=submit name='actionControleur' value='Accueil'/></form>";
        break;
    default: // sans doute etape=bug
        echo "bug";
        exit(1);
}
// seul echo nécessaire toute la pageHTML a été générée dans la variable $pageHTML
echo $pageHTML;

?>