<?php

function getFinHTML(): string {
    return "<!-- contenu -->
    </body>
    </html>
    ";
}

// initialisation de la connexion via l'instance de MyPDO
$myPDOCategorie = new MyPDO($_ENV['host'], $_ENV['db'], $_ENV['user'], $_ENV['password'], 'Categorie');

// initialisation du générateur de vues HTML
$vue = new VueCategorie();

// initialisation des chaînes à afficher
$contenu = "";
$message = "";

// traitement des différentes actions possibles

if (isset($_GET['action']))
{
    switch ($_GET['action'])
    {
        case 'read':
            $categorie = $myPDOCategorie->get('id_categorie', $_GET['id_categorie']);
            $contenu .= $vue->getHTML4Categorie($categorie);
            $_SESSION['etat'] = 'lecture';
            break;
        case 'create':
            $nbCategorie = $myPDOCategorie->count();
            $contenu .= $vue->getFormulaire4Categorie(array('id_categorie' => array ('type'=>'number', 'default'=> $nbCategorie+1), 'robe_bouteille' => 'text', 'sucrage_bouteille' => 'text', 'type_bouteille' => 'text'));
            $_SESSION['etat'] = 'création';
            break;
        case 'update':
            $categorie = $myPDOCategorie->get('id_categorie', $_GET['id_categorie']);
            $contenu .= $vue->getFormulaire4Categorie(array('id_categorie'=>array('type'=>'number','default'=>$categorie->getId_categorie()),
            'robe_bouteille'=>array('type'=>'text','default'=>$categorie->getRobe_bouteille()),
            'sucrage_bouteille'=>array('type'=>'text','default'=>$categorie->getSucrage_bouteille()),
            'type_bouteille'=>array('type'=>'text','default'=>$categorie->getType_bouteille())));
            $_SESSION['etat'] = 'modification';
            break;
        case 'delete':
            $myPDOCategorie->delete(array('id_categorie'=>$_GET['id_categorie']));
            $_SESSION['etat'] = 'suppression';
            break;
        default:
            $message .= "<p>Action ".$_GET['action']." non implémentée.</p>\n";
    }
}
else
{
    if (isset($_SESSION['etat']))
        switch($_SESSION['etat']) {
            case 'création':
                $myPDOCategorie->insert(array('id_categorie'=>$_GET['id_categorie'], 'robe_bouteille'=>$_GET['robe_bouteille'], 'sucrage_bouteille'=>$_GET['sucrage_bouteille'], 'type_bouteille'=>$_GET['type_bouteille']));
                $_SESSION['etat'] = 'créé';
                break;
            case 'modification':
                $myPDOCategorie->update('id_categorie', array('id_categorie'=>$_GET['id_categorie'], 'robe_bouteille'=>$_GET['robe_bouteille'], 'sucrage_bouteille'=>$_GET['sucrage_bouteille'], 'type_bouteille'=>$_GET['type_bouteille']));
                $_SESSION['etat'] = 'modifié';
                break;
            case 'suppression':
                $_SESSION['etat']= 'supprimé';
                break;
            case 'créé':
            case 'modifié':
            case 'supprimé':
            default:
                $_SESSION['etat'] = 'neutre';
    }
}
    

// affichage du nombre total de Categories :
$nbCategorie = $myPDOCategorie->count();
$message .= "<p>La table Categorie contient ".$nbCategorie." enregistrements.</p>\n";

// sélection/modification/suppression/ d'une Categorie

$contenu .=
    "<form action='?' method='GET'>
        <select name='action'>
            <option value='read'>Lire</option>
            <option value='update'>Modifier</option>
            <option value='delete'>Supprimer</option>
        </select>
        <select name='id_categorie'>";

$lesCategories = array();

$iterateur = new CategorieIterator();
foreach ($iterateur as $categorie)
{
    array_push($lesCategories,$categorie);
    $contenu.= "<option>".$iterateur->key()."</option>";
}
    
$contenu .= "</select>
    <input type='submit' name='envoi' value='Go' />
    </form>\n";


// création d'une nouvelle Categorie
// Attention suppose que le nombre de Categorie présentes correspond au dernier identifiant attribué...
$contenu .="<p><a href='?action=create'>Créer Categorie ";
$contenu .= $myPDOCategorie->getMax("id_categorie") + 1;
$contenu .= "</a> </p>";

// récupération et affichage de la liste des Categories avec liens vers édition/suppresion

$contenu .= $vue->getAllCategorie($lesCategories);


// Production de la page HTML
echo $message;
echo $contenu;
echo getFinHTML();

?>