<?php


function getFinHTML(): string {
    return "<!-- contenu -->
    </body>
    </html>
    ";
}

// initialisation de la connexion via l'instance de MyPDO
$myPDOBouteille = new MyPDO($_ENV['host'], $_ENV['db'], $_ENV['user'], $_ENV['password'], 'Bouteille');

// initialisation du générateur de vues HTML
$vue = new VueBouteille();

// initialisation des chaînes à afficher
$contenu = "";
$message = "";

// traitement des différentes actions possibles

if (isset($_GET['action']))
{
    switch ($_GET['action'])
    {
        case 'read':
            $bouteille = $myPDOBouteille->get('id_bouteille', $_GET['id_bouteille']);
            $contenu .= $vue->getHTML4Bouteille($bouteille);
            $_SESSION['etat'] = 'lecture';
            break;
        case 'create':
            $nbBouteille = $myPDOBouteille->count();
            $contenu .= $vue->getFormulaire4Bouteille(array('id_bouteille' => array ('type'=>'number', 'default'=> $myPDOBouteille->getMax("id_bouteille") + 1), 'nom_bouteille' => 'text', 'volume_bouteille' => 'number', 'millesime_bouteille' => 'number', 'prix_bouteille' => 'number', 'id_categorie' => 'number', 'id_appellation' => 'number'));
            $_SESSION['etat'] = 'création';
            break;
        case 'update':
            $bouteille = $myPDOBouteille->get('id_bouteille', $_GET['id_bouteille']);
            $contenu .= $vue->getFormulaire4Bouteille(array('id_bouteille'=>array('type'=>'number','default'=>$bouteille->getId_bouteille()),
                'nom_bouteille'=>array('type'=>'text','default'=>$bouteille->getNom_bouteille()),
                'volume_bouteille'=>array('type'=>'number','default'=>$bouteille->getVolume_bouteille()),
                'millesime_bouteille'=>array('type'=>'text','default'=>$bouteille->getMillesime_bouteille()),
                'prix_bouteille'=>array('type'=>'number','default'=>$bouteille->getPrix_bouteille()),
                'id_categorie'=>array('type'=>'number','default'=>$bouteille->getId_categorie()),
                'id_appellation'=>array('type'=>'number','default'=>$bouteille->getId_appellation())));
            $_SESSION['etat'] = 'modification';
            break;
        case 'delete':
            $myPDOBouteille->delete(array('id_bouteille'=>$_GET['id_bouteille']));
            $_SESSION['etat'] = 'suppression';
            break;
        default:
            $message .= "<p>Action ".$_GET['action']." non implémentée.</p>\n";
    }
}
else
{
    if (isset($_SESSION['etat']))
        switch($_SESSION['etat']) {
            case 'création':
                $myPDOBouteille->insert(array('id_bouteille'=>$_GET['id_bouteille'], 'nom_bouteille'=>$_GET['nom_bouteille'], 'volume_bouteille'=>$_GET['volume_bouteille'], 'millesime_bouteille'=>$_GET['millesime_bouteille'], 'prix_bouteille'=>$_GET['prix_bouteille'], 'id_categorie'=>$_GET['id_categorie'], 'id_appellation'=>$_GET['id_appellation']));
                $myPDOQuantite = new MyPDO($_ENV['host'], $_ENV['db'], $_ENV['user'], $_ENV['password'], 'Quantite');
                $myPDOQuantite->insert(array('nom_bouteille'=>$_GET['nom_bouteille'], 'volume_bouteille'=>$_GET['volume_bouteille'], 'millesime_bouteille'=>$_GET['millesime_bouteille'], 'qte_bouteille'=>1));
                $_SESSION['etat'] = 'créé';
                break;
            case 'modification':
                $myPDOBouteille->update('id_bouteille', array('id_bouteille'=>$_GET['id_bouteille'], 'nom_bouteille'=>$_GET['nom_bouteille'], 'volume_bouteille'=>$_GET['volume_bouteille'], 'millesime_bouteille'=>$_GET['millesime_bouteille'], 'prix_bouteille'=>$_GET['prix_bouteille'], 'id_categorie'=>$_GET['id_categorie'], 'id_appellation'=>$_GET['id_appellation']));
                $_SESSION['etat'] = 'modifié';
                break;
            case 'suppression':
                $_SESSION['etat']= 'supprimé';
                break;
            case 'créé':
            case 'modifié':
            case 'supprimé':
            default:
                $_SESSION['etat'] = 'neutre';
        }
}


// affichage du nombre total de bouteilles :
$nbBouteille = $myPDOBouteille->count();
$message .= "<p>La table Bouteille contient ".$nbBouteille." enregistrements.</p>\n";

// sélection/modification/suppression/ d'une bouteille

$contenu .=
    "<form action='?' method='GET'>
        <select name='action'>
            <option value='read'>Lire</option>
            <option value='update'>Modifier</option>
            <option value='delete'>Supprimer</option>
        </select>
        <select name='id_bouteille'>";

$lesBouteilles = array();

$iterateur = new BouteilleIterator();
foreach ($iterateur as $bouteille)
{
    array_push($lesBouteilles,$bouteille);
    $contenu.= "<option>".$iterateur->key()."</option>";
}

$contenu .= "</select>
    <input type='submit' name='envoi' value='Go' />
    </form>\n";

// création d'une nouvelle bouteille
// Attention suppose que le nombre de bouteille présentes correspond au dernier identifiant attribué...
$contenu .="<p><a href='?action=create'>Créer Bouteille ";
$contenu .= $myPDOBouteille->getMax("id_bouteille") + 1;
$contenu .= "</a> </p>";

// récupération et affichage de la liste des bouteilles avec liens vers édition/suppresion
$contenu .= $vue->getAllBouteille($lesBouteilles);


// Production de la page HTML
echo $message;
echo $contenu;
echo getFinHTML();

?>