<?php

function getFinHTML(): string {
    return "<!-- contenu -->
</body>
</html>
";
}

    // initialisation de la connexion via l'instance de MyPDO
$myPDOOenologue = new MyPDO($_ENV['host'], $_ENV['db'], $_ENV['user'], $_ENV['password'], 'oenologue');

    // initialisation du générateur de vues HTML
$vue = new VueOenologue();

    // initialisation des chaînes à afficher
$contenu = "";
$message = "";

    // traitement des différentes actions possibles

if (isset($_GET['action']))
    switch ($_GET['action']) {
        case 'read':
            $oenologue = $myPDOOenologue->get('id_oenologue', $_GET['id_oenologue']);
            $contenu .= $vue->getHTML4Oeonologue($oenologue);
            $_SESSION['etat'] = 'lecture';
            break;
        case 'create':
            $nbOenologue = $myPDOOenologue->count();
            $contenu .= $vue->getFormulaire4Oeonologue(array('id_oenologue' => array ('type'=>'number', 'default'=> $nbOenologue+1), 'nom_oenologue' => 'text', 'liv_depotlegal' => 'date'));
            $_SESSION['etat'] = 'création';
            break;
        case 'update':
            $oenologue = $myPDOOenologue->get('id_oenologue',$_GET['id_oenologue']);
            $contenu .= $vue->getFormulaire4Oeonologue(array('id_oenologue'=>array('type'=>'number','default'=>$oenologue->getLivNum()),
                'nom_oenologue'=>array('type'=>'text','default'=>$oenologue->getLivTitre())));
            $_SESSION['etat'] = 'modification';
            break;
        case 'delete':
            $myPDOOenologue->delete(array('id_oenologue'=>$_GET['id_oenologue']));
            $_SESSION['etat'] = 'suppression';
            break;
        default:
            $message .= "<p>Action ".$_GET['action']." non implémentée.</p>\n";
    }

else
    if (isset($_SESSION['etat']))
        switch($_SESSION['etat']) {
            case 'création':
                $myPDOOenologue->insert(array('id_oenologue'=>$_GET['id_oenologue'], 'nom_oenologue'=>$_GET['nom_oenologue']));
                $_SESSION['etat'] = 'créé';
                break;
            case 'modification':
                $myPDOOenologue->update('id_oenologue', array('id_oenologue'=>$_GET['id_oenologue'], 'nom_oenologue'=>$_GET['nom_oenologue']));
                $_SESSION['etat'] = 'modifié';
                break;
            case 'suppression':
                $_SESSION['etat']= 'supprimé';
                break;
            case 'créé':
            case 'modifié':
            case 'supprimé':
            default:
                $_SESSION['etat'] = 'neutre';
        }


    // affichage du nombre total de livre :
$nbOenologue = $myPDOOenologue->count();
$message .= "<p>La table oenologue contient ".$nbOenologue." enregistrements.</p>\n";

    // sélection/modification/suppression/ d'un livre

    $contenu .=
        "<form action='?' method='GET'>
            <select name='action'>
            <option value='read'>Lire</option>
            <option value='update'>Modifier</option>
            <option value='delete'>Supprimer</option>
</select>
<input type='number' min='1' max='$nbOenologue' name='id_oenologue'/>
<input type='submit' name='envoi' value='Go' />
</form>\n";


    // création d'un nouveau livre
    // Attention suppose que le nombre de livre présent correspond au dernier identifiant attribué...
$contenu .="<p><a href='?action=create'>Créer oenologue ";
$contenu .= $nbOenologue+1;
$contenu .= "</a> </p>";

    // récupération et affichage de la liste des livres avec liens vers édition/suppresion

$lesOenologues = $myPDOOenologue->getAll();
$contenu .= $vue->getAllOeonologue($lesOenologues);

    // Production de la page HTML
echo $message;
echo $contenu;
echo getFinHTML();
