<?php

include "../MyPDO.php";
include "../Vues/VueDegustation.php";
include "../bdd.php";

function getFinHTML(): string {
    return "<!-- contenu -->
</body>
</html>
";
}

session_start();

// initialisation de la connexion via l'instance de MyPDO
$myPDODegustation = new MyPDO($_ENV['host'], $_ENV['db'], $_ENV['user'], $_ENV['password'], 'Degustation');

// initialisation du générateur de vues HTML
$vue = new VueDegustation();

// initialisation des chaînes à afficher
$contenu = "";
$message = "";

// traitement des différentes actions possibles

if (isset($_GET['action']))
    switch ($_GET['action']) {
        case 'read':
            $Degustation = $myPDODegustation->get('id_degustation', $_GET['id_degustation']);
            $contenu .= $vue->getHTML4Degustation($Degustation);
            $_SESSION['etat'] = 'lecture';
            break;
        case 'create':
            $nbDegustation = $myPDODegustation->count();
            $contenu .= $vue->getFormulaire4Degustation(array('id_degustation' => array ('type'=>'number', 'default'=> $nbDegustation+1),'note_degustation' => 'number', 'date_degustation' => 'date',
                'id_bouteille' => 'number', 'id_oenologue' => 'number'));
            $_SESSION['etat'] = 'création';
            break;
        case 'update':
            $Degustation = $myPDODegustation->get('id_degustation',$_GET['id_degustation']);
            $contenu .= $vue->getFormulaire4Degustation(array('id_Degustation'=>array('type'=>'number','default'=>$Degustation->getIdDegustation()),
                'note_degustation'=>array('type'=>'number','default'=>$Degustation->getNote_degustation()),
                'date_degustation'=>array('type'=>'date','default'=>$Degustation->getDate_degustation()),
                'id_bouteille'=>array('type'=>'number','default'=>$Degustation->getId_bouteille()),
                'id_oenologue'=>array('type'=>'number','default'=>$Degustation->getId_oenologue())));
            $_SESSION['etat'] = 'modification';
            break;
        case 'delete':
            $myPDODegustation->delete(array('id_degustation'=>$_GET['id_degustation']));
            $_SESSION['etat'] = 'suppression';
            break;
        default:
            $message .= "<p>Action ".$_GET['action']." non implémentée.</p>\n";
    }

else
    if (isset($_SESSION['etat']))
        switch($_SESSION['etat']) {
            case 'création':
                $myPDODegustation->insert(array('id_degustation'=>$_GET['id_degustation'],
                    'note_degustation'=>$_GET['note_degustation'], 'date_degustation'=>$_GET['date_degustation'],
                    'id_bouteille'=>$_GET['id_bouteille'], 'id_oenologue'=>$_GET['id_oenologue']));
                $_SESSION['etat'] = 'créé';
                break;
            case 'modification':
                $myPDODegustation->update('id_degustation', array('id_degustation'=>$_GET['id_degustation'],
                    'note_degustation'=>$_GET['note_degustation'], 'date_degustation'=>$_GET['date_degustation'],
                    'id_bouteille'=>$_GET['id_bouteille'], 'id_oenologue'=>$_GET['id_oenologue']));
                $_SESSION['etat'] = 'modifié';
                break;
            case 'suppression':
                $_SESSION['etat']= 'supprimé';
                break;
            case 'créé':
            case 'modifié':
            case 'supprimé':
            default:
                $_SESSION['etat'] = 'neutre';
        }


// affichage du nombre total d'appellations :
$nbDegustation = $myPDODegustation->count();
$message .= "<p>La table Degustation contient ".$nbDegustation." enregistrements.</p>\n";

// sélection/modification/suppression/ d'une appellation

$contenu .=
    "<form action='?' method='GET'>
            <select name='action'>
            <option value='read'>Visualiser une degustation</option>
            <option value='update'>Modifier</option>
            <option value='delete'>Supprimer</option>
            </select>
            <input type='number' min='1' max='$nbDegustation' name='id_Degustation'/>
            <input type='submit' name='envoi' value='Go' />
        </form>\n";


// création d'une nouvelle appellation
// Attention suppose que le nombre de degustations présentent correspond au dernier identifiant attribué...
$contenu .="<p><a href='?action=create'>Créer une degustation ";
$contenu .= $nbDegustation+1;
$contenu .= "</a> </p>";

// récupération et affichage de la liste des degustations avec liens vers édition/suppresion

$lesDegustation = $myPDODegustation->getAll();
$contenu .= $vue->getAllDegustation($lesDegustation);

// Production de la page HTML
echo $message;
echo $contenu;
echo getFinHTML();
