<?php

class Appellation{
    /**
     * gestion statique des accès SGBD
     * @var PDO
     */ 
    private static $_pdo;

    /**
     * gestion statique de la requête préparée de selection
     * @var PDOStatement
     */ 
    private static $_pdos_select;

    /**
     * gestion statique de la requête préparée de mise à jour
     *  @var PDOStatement
     */ 
    private static $_pdos_update;

    /**
     * gestion statique de la requête préparée de d'insertion
     * @var PDOStatement
     */ 
    private static $_pdos_insert;

    /**
     * gestion statique de la requête préparée de suppression
     * @var PDOStatement
     */ 
    private static $_pdos_delete;

    /**
     * PreparedStatement associé à un SELECT, calcule le nombre d'appellations de la table
     * @var PDOStatement;
        */
    private static $_pdos_count;

    /**
     * PreparedStatement associé à un SELECT, récupère toutes les appellations
     * @var PDOStatement;
        */
     private static $_pdos_selectAll;



    /**
     * Initialisation de la connexion et mémorisation de l'instance PDO dans Appellation::$_pdo
     */ 
    public static function initPDO() {
        require "parametres.php";
        self::$_pdo = new PDO("pgsql:host=".$db_host.";dbname=".$db_name,$db_user,$db_passwd);
        // pour récupérer aussi les exceptions provenant de PDOStatement
        self::$_pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    }

    /**
     * préparation de la requête SELECT * FROM Appellation
     * instantiation de self::$_pdos_selectAll
    */
    public static function initPDOS_selectAll() {
        self::$_pdos_selectAll = self::$_pdo->prepare('SELECT * FROM Appellation');
    }

    /**
     * méthode statique instanciant Appellation::$_pdo_select
     */ 
    public static function initPDOS_select() {
        self::$_pdos_select = self::$_pdo->prepare('SELECT * FROM Appellation WHERE id_appellation= :numero');
    }

    /**
     * méthode statique instanciant Appellation::$_pdo_update
     */ 
    public static function initPDOS_update() {
        self::$_pdos_update =  self::$_pdo->prepare('UPDATE Appellation SET nom_appellation=:nom, categorie_appellation=:categorie WHERE id_appellation=:id');
    }

    /**
     * méthode statique instanciant Appellation::$_pdo_insert
     */ 
    public static function initPDOS_insert() {
        self::$_pdos_insert = self::$_pdo->prepare('INSERT INTO Appellation (nom_appellation,categorie_appellation) VALUES(:nom,:categorie)');
    }

    /**
     * méthode statique instanciant Appellation::$_pdo_delete
     */ 
    public static function initPDOS_delete() {
        self::$_pdos_delete = self::$_pdo->prepare('DELETE FROM Appellation WHERE id_appellation=:id');
    }

    /**
     * préparation de la requête SELECT COUNT(*) FROM Appellation
     * instantiation de self::$_pdos_count
        */
        public static function initPDOS_count() {
            if (!isset(self::$_pdo))
                self::initPDO();
            self::$_pdos_count = self::$_pdo->prepare('SELECT COUNT(*) FROM Appellation');
        }
    
    
         /**
         *  identifiant dans la table Appellation
         * @var int
         */ 
        protected $id_appellation;
    
        /**
         * nom de l'apellation (Bordeaux,Côte du Rhones...)
         * @var string
         */ 
        protected $nom_appellation;
    
        /**
         * categorie de l'appellation (AOC/AOP...)
         *   @var string
         */ 
        protected $categorie_appellation;
    
        /**
         * attribut interne pour différencier les nouveaux objets des objets créés côté applicatif de ceux issus du SGBD
         * @var bool
         */ 
        private $nouveau = TRUE;
    
        /**
         * @return $this->id_appellation
         */ 
        public function getId_appellation() : int {
            return $this->id_appellation;
        }
    
        /**
         * @param $id_appellation
         */ 
        public function setId_appellation(int $id_appellation): void {
            $this->id_appellation=$id_appellation;
        }
    
        /**
         * @return $this->nom_appellation
         */ 
        public function getNom_appellation() : string {
            return $this->nom_appellation;
        }
    
        /**
         * @param $nom_appellation
         */ 
        public function setNom_appellation(string $nom_appellation): void {
            $this->nom_appellation=$nom_appellation;
        }
    
        /**
         * @return $this->categorie_appellation
         */ 
        public function getCategorie_appellation() : string {
            return $this->categorie_appellation;
        }
    
        /**
         * @param $categorie_appellation
         */ 
        public function setCategorie_appellation(string $categorie_appellation): void {
            $this->categorie_appellation=$categorie_appellation;
        }
    
        /**
         * @return $this->nouveau
         */ 
        public function getNouveau() : bool {
            return $this->nouveau;
        }
    
        /**
         * @param $nouveau
         */ 
        public function setNouveau(bool $nouveau): void {
            $this->nouveau=$nouveau;
        }

    /**
     * @return un tableau de toutes les Appellations
     */ 
    public static function getAll(): array {
        try {
            if (!isset(self::$_pdo))
                self::initPDO();
            if (!isset(self::$_pdos_selectAll))
                self::initPDOS_selectAll();
            self::$_pdos_selectAll->execute();
            // résultat du fetch dans une instance d'Appellation
            $lesAppellations = self::$_pdos_selectAll->fetchAll(PDO::FETCH_CLASS,'Appellation');
            return $lesAppellations;
        }
        catch (PDOException $e) {
            print($e);
        }
    }

    /**
     * initialisation d'un objet à partir d'un enregistrement d'appellation
     * @param $id_appellation , identifiant d'appelaltion
     * @return l'instance de classe Appellation associée à $id_appellation
     */ 
    public static function initAppellation($id_appellation) : Appellation {
        try {
	        if (!isset(self::$_pdo))
	            self::initPDO();
	        if (!isset(self::$_pdos_select))
	            self::initPDOS_select();
	        self::$_pdos_select->bindValue(':numero',$id_appellation);
	        self::$_pdos_select->execute();
        // résultat du fetch dans une instance d'Appellation
	        $app = self::$_pdos_select->fetchObject('Appellation');
	        if (isset($app) && ! empty($app))
	            $app->setNouveau(FALSE);
	        if (empty($app))
                throw new Exception("Appellation numero $id_appellation inexistante dans la table Appellation.\n");
	        return $app;
        }
        catch (PDOException $e) {
	        print($e);
        }
    }

    /**
     * sauvegarde d'un objet 
     * soit on insère un nouvel objet
     * soit on le met à jour
     */ 
    public function save() : void {
        if (!isset(self::$_pdo))
            self::initPDO();
        if ($this->nouveau) {
            if (!isset(self::$_pdos_insert)) {
	            self::initPDOS_insert();
            }
            self::$_pdos_insert->bindParam(':nom', $this->nom_appellation);
            self::$_pdos_insert->bindParam(':categorie', $this->categorie_appellation);
            self::$_pdos_insert->execute();
            $this->setNouveau(FALSE);
        }
        else {
            if (!isset(self::$_pdos_update))
	            self::initPDOS_update();
            self::$_pdos_update->bindParam(':nom', $this->nom_appellation);
            self::$_pdos_update->bindParam(':categorie', $this->categorie_appellation);
            self::$_pdos_update->execute();
        }
    }

    /**
     * suppression d'un objet 
     */ 
    public function delete() :void {
        if (!isset(self::$_pdo))
            self::initPDO();
        if (!$this->nouveau) {
            if (!isset(self::$_pdos_delete)) {
	            self::initPDOS_delete();
            }
            self::$_pdos_delete->bindParam(':id', $this->id_appellation);
            self::$_pdos_delete->execute();
        }
        $this->setNouveau(TRUE);
    }

    /**
     * nombre d'objets disponibles dans la table
     */
    public static function getNbAppellation() : int {
        if (!isset(self::$_pdos_count)) {
            self::initPDOS_count();
        }
        self::$_pdos_count->execute();
        $resu = self::$_pdos_count->fetch();
        return $resu[0];
    }


    /**
     * affichage élémentaire
     */ 
    public function __toString() : string {
        $ch = "<table border='1'><tr><th>id_appellation</th><th>nom_appellation</th><th>categorie_appellation</th><th>nouveau</th></tr><tr>";
        $ch.= "<td>".$this->id_appellation."</td>";
        $ch.= "<td>".$this->nom_appellation."</td>";
        $ch.= "<td>".$this->categorie_appellation."</td>";
        $ch.= "<td>".$this->nouveau."</td>";
        $ch.= "</tr></table>";
        return $ch;
    }
}
    

?>