import './index.css';
import nameGenerator from './name-generator';
import isDef from './is-def';
  
  

// Store/retrieve the name in/from a cookie.
const cookies = document.cookie.split(';');
console.log(cookies)
let wsname = cookies.find(function(c) {
  if (c.match(/wsname/) !== null) return true;
  return false;
});
if (isDef(wsname)) {
  wsname = wsname.split('=')[1];
} else {
  wsname = nameGenerator();
  document.cookie = "wsname=" + encodeURIComponent(wsname);
}

// Set the name in the header
document.querySelector('header>p').textContent = decodeURIComponent(wsname);

// Create a WebSocket connection to the server
 const ws = new WebSocket("ws://" + window.location.host+ "/socket");

// We get notified once connected to the server
ws.onopen = (event) => {
  console.log("We are connected.");
};

const msg = document.querySelector('#messages');
const selectedBoard = document.querySelector('#selectedBoard');
const lineWidth = document.querySelector('#linewidth');
const colorSelect = document.querySelector('#color-select');
let canvas = document.querySelector("canvas");
let ctx = canvas.getContext("2d");
let list = document.querySelector('#listboard');
let selectLi = [].slice.call(list.children).find(li => li.getAttribute('value') === canvas.id);
selectLi.style.background = '#70cdf5 ';

list.addEventListener('click', event => {
  if (canvas.id !== event.target.getAttribute('value')) {
      selectedBoard.textContent = 'Board ' + event.target.getAttribute('value');
      selectLi.style.background = null;
      selectLi = [].slice.call(list.children).find(li =>
          li.getAttribute('value') === event.target.getAttribute('value'));
      selectLi.style.background = '#70cdf5';
      let donnee = {
          message: 'board-change',
          canvas: parseInt(event.target.getAttribute('value'))
      }
      ws.send(JSON.stringify(donnee));
  }

});

let buttonAdd = document.querySelector('.btn-add');
buttonAdd.addEventListener('click', evt => {
    let l = list.children[list.children.length - 1];
    let donnee = {
        message: 'new-Board',
        value: parseInt(l.getAttribute('value')) + 1
    }
    ws.send(JSON.stringify(donnee));
});

let buttonClear = document.querySelector('.btn-clear');
buttonClear.addEventListener('click', event => {

    let donnee = {
        message: 'clear-Board',
        canvas: parseInt(canvas.id)
    }
    ws.send(JSON.stringify(donnee));
});

function add(e) {
  let l = document.createElement('li');
  l.innerHTML = 'Board ' + e;
  l.setAttribute("value", e + '')
  list.appendChild(l);
}

ws.onmessage = (event) => {
  let data = JSON.parse(event.data);
  switch (data.message) {

      case 'welcome_Message' :
          let ligne = document.createElement('li');
          ligne.textContent = data.data.welcomeMessage;
          msg.appendChild(ligne);
          console.log(data.data.chatHistory);
          for (let message of data.data.chatHistory) {
              ligne = document.createElement('li');
              ligne.textContent = message;
              msg.appendChild(ligne);
          }
          break;
      case 'chat-message' :
          let newMessage = document.createElement('li');
          newMessage.textContent = data.data;
          msg.appendChild(newMessage);
          break;       
      case 'first_connexion' :
          for (let id of data.boards)
              add(id);
          if (data.firstBoard.length) {
              for (let obj of data.firstBoard)
                  draw(obj);
          }
          break;
      case 'draw' :
          let id = data.data.canvas;
          if (parseInt(canvas.id) === id) {
              draw(data.data);
          }
          break;
      case 'new-Board' :
          add(data.value);
          break;
      case 'board-change' :
          ctx.clearRect(0, 0, canvas.width, canvas.height);
          canvas.id = data.canvas + '';
          for (let obj of data.dessin)
              draw(obj);
          break;
      case 'clear-Board' :
          if (parseInt(canvas.id) === data.canvas){
              ctx.clearRect(0, 0, canvas.width, canvas.height);
          }
          break;
  }
};

let drawing = false;
let prevX;
let prevY;
let dim;

function draw(obj) {
    ctx.beginPath();
    ctx.strokeStyle = `${obj.color}`;
    ctx.lineWidth = parseInt(obj.width);
    ctx.moveTo(obj.coords.x1, obj.coords.y1);
    ctx.lineTo(obj.coords.x2, obj.coords.y2);
    ctx.stroke();
    ctx.closePath();
}

function start(e) {
  dim = canvas.getBoundingClientRect();
  canvas = document.querySelector("canvas");
  ctx = canvas.getContext("2d");
  prevX = e.clientX - dim.left;
  prevY = e.clientY - dim.top;
  drawing = true;
}

function sendDraw(e) {
  if (drawing) {
      dim = canvas.getBoundingClientRect();
      let shape = {
          canvas: parseInt(canvas.id),
          color: colorSelect.value,
          width: lineWidth.value,
          coords: {
              x1: prevX,
              y1: prevY,
              x2: e.clientX - dim.left,
              y2: e.clientY - dim.top
          }
      };
      let data = {
          message: 'draw',
          data: shape
      }
      ws.send(JSON.stringify(data));
      prevX = e.clientX - dim.left;
      prevY = e.clientY - dim.top;
  }
}

function stop(event) {
  drawing = false;
}

function sendMessage(event) {
  event.preventDefault();
  event.stopPropagation();
  if (sendInput.value !== '') {
      let data = {
          message: 'chat-message',
          data: sendInput.value
      }
      ws.send(JSON.stringify(data));
      sendInput.value = '';
  }
}

canvas.addEventListener('mousedown', start);
canvas.addEventListener('mousemove', sendDraw);
window.addEventListener('mouseup', stop);
const sendForm = document.querySelector('form');
const sendInput = document.querySelector('form input');
sendForm.addEventListener('submit', sendMessage, true);




