var http = require('http'),
  WebSocketServer = require('ws').Server,
  port = 1234,
  host = '0.0.0.0';

// create a new HTTP server to deal with low level connection details (tcp connections, sockets, http handshakes, etc.)
var server = http.createServer();

class Board {
  constructor(id) {
      this._id = id;
      this._draw = [];
  }
  get id() {
      return this._id;
  }
  get draw() {
      return this._draw;
  }
  set draw(draw) {
      this._draw = draw;
  }
}

let newBoard = new Board(1);
let listBoard = [];
listBoard.push(newBoard);
let chatHistory = [];


// create a WebSocket Server on top of the HTTP server to deal with the WebSocket protocol
var wss = new WebSocketServer({
  server: server
});

// create a function to be able do broadcast messages to all WebSocket connected clients
wss.broadcast = function broadcast(message) {
  wss.clients.forEach(function each(client) {
    client.send(message);
  });
};

// Register a listener for new connections on the WebSocket.
wss.on('connection', function(client, request) {

  // retrieve the name in the cookies
  var cookies = request.headers.cookie.split(';');
  var wsname = cookies.find((c) => {
    return c.match(/^\s*wsname/) !== null;
  });
  wsname = wsname.split('=')[1];

  // greet the newly connected user
  let welcomeMessage = {
    message: 'welcome_Message',
    data: {
        welcomeMessage: 'Welcome, ' + decodeURIComponent(wsname) + '!',
        chatHistory: chatHistory
    }
}
client.send(JSON.stringify(welcomeMessage));

  // Register a listener on each message of each connection
  let historiqueBoard = {
    message: 'first_connexion',
    firstBoard: listBoard[0].draw,
    boards: listBoard.map(board => board.id).filter(id => id !== 1)
  }
  client.send(JSON.stringify(historiqueBoard));
  client.on('message', function (message) {
    var cli = '[' + decodeURIComponent(wsname) + '] ';
        console.log("message from", cli);
        let board;
        let data = JSON.parse(message);
        switch (data.message) {
          case 'draw' :
                board = listBoard.find(board => board.id === data.data.canvas);
                board.draw.push(data.data);
                wss.broadcast(message);
                break;
            case 'new-Board' :
                newBoard = new Board(data.value);
                listBoard.push(newBoard);
                wss.broadcast(message);
                break;
            case 'board-change' :
                board = listBoard.find(board => board.id === data.canvas);
                data.dessin = board.draw;
                client.send(JSON.stringify(data));
                break;
            case 'chat-message' :
                data.data = cli + data.data;
                chatHistory.push(data.data);
                wss.broadcast(JSON.stringify(data));
                break;
            case 'clear-Board' :
                board = listBoard.find(board => board.id === data.canvas);
                board.draw = [];
                wss.broadcast(message);
                break;
        }
    });
});


// http sever starts listening on given host and port.
server.listen(port, host, function() {
  console.log('Listening on ' + server.address().address + ':' + server.address().port);
});

process.on('SIGINT', function() {
  process.exit(0);
});