import { render, unmountComponentAtNode } from "react-dom";
import SensorList from '../routes/SensorList';
import { BrowserRouter } from "react-router-dom";
import { screen } from "@testing-library/react";

let container = null;
beforeEach(() => {
  // met en place un élément DOM comme cible de rendu
  container = document.createElement("div");
  document.body.appendChild(container);
});

afterEach(() => {
  // nettoie en sortie de test
  unmountComponentAtNode(container);
  container.remove();
  container = null;
});

describe('Sensor list', () => {
it('create sensor list with data', () => {
  const sensorData = JSON.parse(`[
    {
        "id": 2222,
        "name": "Ventilateur Ordinateur Bureau",
        "type": "FAN_SPEED",
        "data": {
            "labels": [
                "2021-01-19T10:00:00.000Z","2021-01-19T10:05:00.000Z",
                "2021-01-19T10:10:00.000Z","2021-01-19T10:15:00.000Z",
                "2021-01-19T10:20:00.000Z","2021-01-19T10:25:00.000Z"
            ],
            "values": [
                1073,1800,
                2299,2176,
                1899,1400
            ]
        }
    },
    {
        "id": 34561,
        "name": "Lumière salon",
        "type": "LIGHT",
        "data": {
            "value": 70
        }
    },
    {
        "id": 45678,
        "name": "Interrupteur cuisine",
        "type": "SWITCH",
        "data": {
            "value": 0
        }
    }
]`);
   render(
      <BrowserRouter>
        <SensorList sensorData={sensorData} />
      </BrowserRouter>,
      container
    );
    expect(screen.getAllByTestId('sensorLink').length).toBe(3)
})

it('sensor list without data', () => {
    render(
      <BrowserRouter>
        <SensorList/>
      </BrowserRouter>,
      container
    );
    expect(screen.getByTestId('sensorNoData')).toBeInTheDocument()
})})
