import { render, unmountComponentAtNode } from "react-dom";
import SensorInfo from "../routes/SensorInfo";
import { screen } from "@testing-library/react";

let conteneur = null;
beforeEach(() => {
  // met en place un élément DOM comme cible de rendu
  conteneur = document.createElement("div");
  document.body.appendChild(conteneur);
});

afterEach(() => {
  // nettoie en sortie de test
  unmountComponentAtNode(conteneur);
  conteneur.remove();
  conteneur = null;
});

describe("Sensor info", () => {
  const sensorData = JSON.parse(`[{
    "id": 45678,
    "name": "Interrupteur cuisine",
    "type": "SWITCH",
    "data": {
        "value": 0
    }
}]`);
  it("Sensor sans données", () => {
    render(<SensorInfo sensorData={sensorData} />, conteneur);
    expect(screen.getByText("Unable to find sensor data")).toBeInTheDocument();
  });
});
