import style from './css/App.module.css';
import Header from './Header';
import SensorList from './routes/SensorList';
import SensorInfo from './routes/SensorInfo';
import React, { useState } from 'react';
import { Route, Routes, useNavigate } from 'react-router-dom';


function App() {
  const navigate = useNavigate();
  const [sensorData, setSensorData] = useState(null);
  const [url, setUrl] = useState(null);
  return (
    <div className={style.App}>
      <Header className={style.header} onChange={(evt) => setUrl(evt.target.value)} onClick={tryLoadData} />
      <Routes>
        <Route 
          index
          element={
            <main className={style.center}>
              <p data-testid="indexRouteText">Entrer une url pour accéder au données</p>
            </main>
          } 
        />
        <Route path='dataError' element={<main className={style.center}><span data-testid="dataError">Erreur lors de la récupération des données de l'url</span></main>}/>
        <Route path='view' element={<SensorList sensorData={sensorData}/>}>
          <Route path=':sensorName' element={<SensorInfo sensorData={sensorData} />} />
        </Route>
        <Route
          path="*"
          element={
            <main className={style.center}>
              <p>Il n y a rien ici </p>
            </main>
          }
        />
      </Routes>
    </div>
  );


export default App;
