'use strict';

const passport = require('../passeport-config');
const User = require('../models/User');

passport.use(User.createStrategy());

/**
 * Create user
 * This can only be done by the logged in user.
 *
 * body User Created user object (optional)
 * returns User
 **/
exports.createUser = async function(username, password, isAgent) {
  const existingUser = await User.findOne({ username });

  if (existingUser) {
    throw new Error('This user already exists.');
  }

  await User.register(new User ({ username : username, isAgent : isAgent}), password);
};

/**
 * Logs user into the system
 *
 * username String The user name for login (optional)
 * password String The password for login in clear text (optional)
 * returns String
 **/
exports.isAuthenticated = function (req, res, next) {
  if (req.isAuthenticated()) {
    return true;
  }
  return false;
}

