const Ad = require('../models/Ad');

// Méthode pour ajouter une nouvelle annonce
exports.addAd = function (body) {
  return new Promise(async (resolve, reject) => {
    try {
      const newAd = new Ad(body);
      const savedAd = await newAd.save();
      resolve(savedAd);
    } catch (error) {
      reject(error);
    }
  });
}

// Méthode pour supprimer une annonce par son ID
exports.deleteAd = function (AdId) {
  return new Promise(async (resolve, reject) => {
    try {
      const deletedAd = await Ad.findByIdAndRemove(AdId);
      if (!deletedAd) {
        reject('Annonce non trouvée');
      } else {
        resolve('Annonce supprimée avec succès');
      }
    } catch (error) {
      reject(error);
    }
  });
}

// Méthode pour récupérer toutes les annonces
exports.getAllAds = function () {
  return new Promise(async (resolve, reject) => {
    try {
      const Ads = await Ad.find();
      resolve(Ads);
    } catch (error) {
      reject(error);
    }
  });
}

// Méthode pour récupérer une annonce par son ID
exports.getAdById = function (AdId) {
  return new Promise(async (resolve, reject) => {
    try {
      const Ad = await Ad.findById(AdId);
      if (!Ad) {
        reject('Annonce non trouvée');
      } else {
        resolve(Ad);
      }
    } catch (error) {
      reject(error);
    }
  });
}

// Méthode pour mettre à jour une annonce par son ID
exports.updateAd = function (AdId, body) {
  return new Promise(async (resolve, reject) => {
    try {
      const updatedAd = await Ad.findByIdAndUpdate(
          AdId,
          body,
          { new: true }
      );
      if (!updatedAd) {
        reject('Annonce non trouvée');
      } else {
        resolve(updatedAd);
      }
    } catch (error) {
      reject(error);
    }
  });
}

// Méthode pour rechercher des annonces par statut
exports.findAdsByStatus = function (status) {
  return new Promise(async (resolve, reject) => {
    try {
      const Ads = await Ad.find({ publicationStatus: status });
      resolve(Ads);
    } catch (error) {
      reject(error);
    }
  });
}

// Méthode pour rechercher des annonces par type de propriété
exports.findAdsByPropertyType = function (propertyType) {
  return new Promise(async (resolve, reject) => {
    try {
      const Ads = await Ad.find({ propertyType });
      resolve(Ads);
    } catch (error) {
      reject(error);
    }
  });
}
