const mongoose = require('mongoose');
require('dotenv').config();

const dbName = process.env.DB_NAME;
const url = `mongodb://172.24.0.2:27017/${dbName}`;

const connectToDatabase = async () => {
    try {
        await mongoose.connect(url, { useNewUrlParser: true, useUnifiedTopology: true });
        console.log(`Connected to database ${dbName}`);
    } catch (err) {
        console.error(err);
        throw err;
    }
};

module.exports = connectToDatabase;
