const express = require('express');
const passport = require('../passeport-config');
const jwt = require('jsonwebtoken');
const utils = require('../utils/writer.js');

const { typeDefs, resolvers } = require('../schemas/User&AdSchema');

const User = require('../service/UserService');

const authRouter = express.Router();

authRouter.post('/', async (req, res) => {
    try {
        const { username, password, isAgent } = req.body;
        user = await User.createUser(username, password, isAgent);
        console.log("user", user)
        utils.writeJson(res, { message: 'Utilisateur créé avec succès', user });
    } catch (error) {
        utils.writeJson(res, { error: error.message });
    }
});

authRouter.post('/login', async (req, res, next) => {
    try {
        passport.authenticate('local', (err, user, info) => {
            if (err) {
                return res.status(500).send(err); // Internal Server Error
            }
            if (!user) {
                return res.status(401).send('Invalid username or password.'); // Unauthorized
            }
            const token = jwt.sign({ username: user.username }, 'secretKey', { expiresIn: '1h' });
            return res.status(200).json({ token });
        })(req, res, next);
    } catch (error) {
        console.error("Erreur lors de la tentative de connexion :", error);
        return res.status(500).send(error);
    }
});

authRouter.post('/logout', async (req, res) => {
    try {
        // Perform logout logic if needed
        return res.status(200).send('Logout successful.'); // Success
    } catch (error) {
        console.error("Erreur lors de la déconnexion de l'utilisateur :", error);
        return res.status(500).send(error);
    }
});

/*
const expressGraphQL = require('express-graphql').graphqlHTTP;

authRouter.use('/graphql', expressGraphQL({
    schema: typeDefs,
    rootValue: resolvers,
    graphiql: true,
}));
*/
module.exports = authRouter;
