'use strict';

const passport = require('../passeport-config');
const User = require('../models/User');

const jwt = require('jsonwebtoken');

passport.use(User.createStrategy());

/**
 * Create user
 * This can only be done by the logged in user.
 *
 * body User Created user object (optional)
 * returns User
 **/
exports.createUser = async function (username, password, isAgent) {
    const existingUser = await User.findOne({username});

    if (existingUser) {
        throw new Error('This user already exists.');
    }

    const user = await User.register(new User({username: username, isAgent: isAgent}), password);
    console.log("user", user)
    return user;
};

/**
 * Logs user into the system
 *
 * username String The user name for login (optional)
 * password String The password for login in clear text (optional)
 * returns String
 **/
exports.isAuthenticated = function (req, res, next) {
    if (req.isAuthenticated()) {
        return next();
    }
    res.status(401).json({message: 'Authentification requise'});
}

exports.extractUserFromToken = function (token, secretKey) {
    return new Promise(async (resolve, reject) => {
        try {
            const decoded = await jwt.verify(token, secretKey);
            // Vérifier la date d'expiration
            const currentTimestamp = Math.floor(Date.now() / 1000);
            if (decoded.exp && decoded.exp < currentTimestamp) {
                reject(new Error('Token expiré.'));
                return;
            }

            const user = await User.findOne({username: decoded.username});

            if (!user) {
                reject(new Error('Utilisateur non trouvé.'));
            } else {
                resolve(decoded);
            }
        } catch (err) {
            reject(err);
        }
    });
};
