const passport = require('passport');
const LocalStrategy = require('passport-local').Strategy;

const User = require('./models/User');

passport.use(new LocalStrategy(
    {usernameField: 'username'},
    function (username, password, done) {
        User.authenticate()(username, password, async function (err, user) {
            if (err) {
                return done(err);
            }
            if (!user) {
                return done(null, false);
            }
            return done(null, user);
        });
    }
));

passport.serializeUser(function (user, done) {
    done(null, user.username);
});

passport.deserializeUser(async function (username, done) {
    try {
        const user = await User.findOne({username: username});
        if (!user) {
            return done(null, false, {message: 'Utilisateur non trouvé.'});
        }
        return done(null, user);
    } catch (error) {
        return done(error);
    }
});

module.exports = passport;