const express = require('express');
const passport = require('../passeport-config');
const jwt = require('jsonwebtoken');
const utils = require('../utils/writer.js');

const {typeDefs, resolvers, schema} = require('../schemas/User&AdSchema');

const User = require('../service/UserService');
const {default: expressPlayground} = require("graphql-playground-middleware-express");
const {createHandler} = require("graphql-http/lib/use/express");
const {extractUserFromToken} = require("../service/UserService");

const extractToken = (req, res, next) => {
    const authorizationHeader = req.headers.authorization;

    if (authorizationHeader && authorizationHeader.startsWith('Bearer ')) {
        req.token = authorizationHeader.slice(7);
        next();
    } else {
        res.status(401).json({ message: 'Authentication is required.' });
    }
};
const secretKey = process.env.SECRET_KEY;

const authRouter = express.Router();

authRouter.post('/', async (req, res) => {
    try {
        const {username, password, isAgent} = req.body;
        user = await User.createUser(username, password, isAgent);
        console.log("user", user)
        utils.writeJson(res, {message: 'Utilisateur créé avec succès', user});
    } catch (error) {
        utils.writeJson(res, {error: error.message});
    }
});

authRouter.post('/login', async (req, res, next) => {
    try {
        passport.authenticate('local', (err, user, info) => {
            if (err) {
                return res.status(500).send(err); // Internal Server Error
            }
            if (!user) {
                return res.status(401).send('Invalid username or password.'); // Unauthorized
            }
            const token = jwt.sign({username: user.username}, secretKey, {expiresIn: '1h'});
            return res.status(200).json({token});
        })(req, res, next);
    } catch (error) {
        console.error("Erreur lors de la tentative de connexion :", error);
        return res.status(500).send(error);
    }
});

authRouter.post('/logout', extractToken, async (req, res) => {
    try {
        // Perform logout logic if needed
        const decoded = await extractUserFromToken(req.token, secretKey);
        if (!decoded) {
            return res.status(401).send('Invalid token.');
        }
        return res.status(200).send('Logout successful.');
    } catch (error) {
        console.error("Erreur lors de la déconnexion de l'utilisateur :", error);
        return res.status(500).send(error);
    }
});

module.exports = authRouter;
