const express = require('express');
const router = express.Router();
const AdService = require('../service/AdService');
const utils = require('../utils/writer.js');
const multer = require('multer');
const upload = multer();
const extractToken = (req, res, next) => {
    const extractToken = (req, res, next) => {
        const authorizationHeader = req.headers.authorization;

        if (authorizationHeader && authorizationHeader.startsWith('Bearer ')) {
            req.token = authorizationHeader.slice(7);
            next();
        } else {
            res.status(401).json({message: 'Authentication is required.'});
        }
    };
};

router.post('/', extractToken, upload.array('photos'), async (req, res) => {
    try {
        const response = await AdService.addAdWithPhotos(req.body, req.files, req.token);
        utils.writeJson(res, response);
    } catch (error) {
        res.status(500).json({message: error.message});
    }
});

router.put('/update/:id', extractToken, upload.array('photos'), async (req, res) => {
    try {
        const response = await AdService.updateAd(req.params.id, req.body, req.files, req.token);
        utils.writeJson(res, response);
    } catch (error) {
        res.status(500).json({message: error.message});
    }
});

router.post('/delete/:id', extractToken, async (req, res) => {
    try {
        const response = await AdService.deleteAd(req.params.id, req.token);
        utils.writeJson(res, response);
    } catch (error) {
        res.status(500).json({message: error.message});
    }
});

router.get('/', extractToken, async (req, res) => {
    try {
        const response = await AdService.getAds(req.token);
        utils.writeJson(res, response);
    } catch (error) {
        res.status(500).json({message: error.message});
    }
});

router.get('/:id', extractToken, async (req, res) => {
    try {
        const response = await AdService.getAdById(req.params.id, req.token);
        utils.writeJson(res, response);
    } catch (error) {
        res.status(500).json({message: error.message});
    }
});

router.put('/:id/ask', extractToken, async (req, res) => {
    const announcementId = req.params.id;
    const {question} = req.body;
    try {
        const response = await AdService.askQuestion(announcementId, question, req.token);
        utils.writeJson(res, response);
    } catch (error) {
        res.status(500).json({message: error.message});
    }
});

router.put('/:id/question/:questionId/answer', extractToken, async (req, res) => {
    const announcementId = req.params.id;
    const questionId = req.params.questionId;
    const {answer} = req.body;
    try {
        const response = await AdService.answerQuestion(announcementId, questionId, answer, req.token);
        utils.writeJson(res, response);
    } catch (error) {
        res.status(500).json({message: error.message});
    }
});

router.post('/:id/photos', extractToken, upload.array('photos'), async (req, res) => {
    try {
        const response = await AdService.addPhotosToAd(req.params.id, req.files);
        utils.writeJson(res, response);
    } catch (error) {
        res.status(500).json({ message: error.message });
    }
});
module.exports = router;
