'use strict';

var path = require('path');
var http = require('http');
var session = require('express-session');

var oas3Tools = require('oas3-tools');
var serverPort = 8080;

// swaggerRouter configuration
var options = {
    routing: {
        controllers: path.join(__dirname, './controllers')
    },
};

var expressAppConfig = oas3Tools.expressAppConfig(path.join(__dirname, 'api/openapi.yaml'), options);
var app = expressAppConfig.getApp();

const connectToDatabase = require('./data-access/connection');
const passport = require("./passeport-config");

// app.use(session({ secret: 'fifiHajar', resave: true, saveUninitialized: true }));
// app.use(passport.initialize());
// app.use(passport.session());

// Connect to the database
connectToDatabase()
    .then(() => {



        // Initialize the Swagger middleware
        http.createServer(app).listen(serverPort, function () {
            console.log('Your server is listening on port %d (http://localhost:%d)', serverPort, serverPort);
            console.log('Swagger-ui is available on http://localhost:%d/docs', serverPort);
        });
    })
    .catch(error => {
        console.error('Error connecting to the database:', error);
    });

