'use strict';

var utils = require('../utils/writer.js');
var User = require('../service/UserService');
var passport = require('../passeport-config');
var UserModel = require('../models/User');

// passport.use(UserModel.createStrategy());

module.exports.createUser = async function(req, res) {
    try {
        const { username, password, isAgent } = req.body;
        await User.createUser(username, password, isAgent);
        utils.writeJson(res, { message: 'Utilisateur créé avec succès' });
    } catch (error) {
        utils.writeJson(res, { error: error.message });
    }
};

module.exports.loginUser = async function loginUser(req, res, next) {
    try {
        passport.authenticate('local', (err, user, info) => {
            if (err) {
                return res.status(500).send(err); // Erreur interne du serveur
            }
            if (!user) {
                return res.status(401).send('Invalid username or password.'); // Non autorisé
            }
            // User.loginUser()
            //  .then(function (response) {
            //      utils.writeJson(res, response);
            //  })
            //  .catch(function (response) {
            //      utils.writeJson(res, response);
            //  });
            return res.status(200).send('Authentication successful.'); // Succès
        })(req, res, next);
    } catch (error) {
        console.error("Erreur lors de la tentative de connexion :", error);
        return res.status(500).send(error);
    }
}

module.exports.logoutUser = function logoutUser (req, res, next) {
  User.logoutUser()
    .then(function (response) {
      utils.writeJson(res, response);
    })
    .catch(function (response) {
      utils.writeJson(res, response);
    });
};

module.exports.logoutUser = function(req, res, next) {
    try {
        /*
        req.logout(function(err) {
            if (err) {
                return next(err);
            }
            res.redirect('/');
        });
        */
        return res.status(200).send('Logout successful.'); // Success
    } catch (error) {
        console.error("Erreur lors de la déconnexion de l'utilisateur :", error);
        return res.status(500).send(error);
    }
};