import 'dart:convert';
import 'package:flutter/material.dart';
import 'data_page.dart';
import 'student_edit_page.dart';

void main() {
  runApp(const MyApp());
}

class MyApp extends StatelessWidget {
  const MyApp({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'Flutter NFC App',
      theme: ThemeData(
        primarySwatch: Colors.deepPurple,
      ),
      home: const HomePage(),
    );
  }
}

class HomePage extends StatefulWidget {
  const HomePage({Key? key}) : super(key: key);

  @override
  _HomePageState createState() => _HomePageState();
}

class _HomePageState extends State<HomePage> {
  final TextEditingController _googleSheetsLinkController = TextEditingController();

  bool _isValidGoogleSheetsLink(String link) {
    RegExp regex = RegExp(r'https:\/\/docs\.google\.com\/spreadsheets\/d\/[a-zA-Z0-9_-]+\/(edit|pubhtml).*');
    return regex.hasMatch(link);
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('Flutter NFC App'),
        backgroundColor: Colors.deepPurple,
      ),
      body: Padding(
        padding: const EdgeInsets.all(16.0),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            const Text(
              'Bienvenue dans votre application NFC !',
              style: TextStyle(fontSize: 20.0, fontWeight: FontWeight.bold, color: Colors.deepPurple),
            ),
            const SizedBox(height: 20.0),
            TextField(
              controller: _googleSheetsLinkController,
              decoration: const InputDecoration(
                labelText: 'Entrez le lien Google Sheets',
                border: OutlineInputBorder(),
                enabledBorder: OutlineInputBorder(
                  borderSide: BorderSide(color: Colors.deepPurple, width: 2.0),
                ),
                focusedBorder: OutlineInputBorder(
                  borderSide: BorderSide(color: Colors.deepPurpleAccent, width: 2.0),
                ),
              ),
            ),
            const SizedBox(height: 20.0),
            ElevatedButton(
              onPressed: () {
                String googleSheetsLink = _googleSheetsLinkController.text;
                if (_isValidGoogleSheetsLink(googleSheetsLink)) {
                  Navigator.push(
                    context,
                    MaterialPageRoute(
                      builder: (context) => DataPage(googleSheetsLink: googleSheetsLink),
                    ),
                  );
                } else {
                  showDialog(
                    context: context,
                    builder: (context) {
                      return AlertDialog(
                        title: const Text('Lien Google Sheets invalide'),
                        content: const Text('Veuillez saisir un lien Google Sheets valide.'),
                        actions: <Widget>[
                          TextButton(
                            onPressed: () {
                              Navigator.pop(context);
                            },
                            child: const Text('OK'),
                            style: TextButton.styleFrom(primary: Colors.deepPurple), // Couleur du texte du bouton
                          ),
                        ],
                      );
                    },
                  );
                }
              },
              child: const Text('Continuer'),
              style: ElevatedButton.styleFrom(
                primary: Colors.deepPurple,
                onPrimary: Colors.white,
              ),
            ),
          ],
        ),
      ),
    );
  }
}
