# nfc

## Lancement de l'application

### configuration de google sheets

- Ajout d'un fichier `config.dart` dans le dossier `lib` avec le contenu suivant :

```dart
class AppConfig {
  static const String apiKey = 'Votre clé d api';
  static const String sheetName = 'Nom de votre sheet name';
}
```

#### Récupération de la clé d'api :

- Accédez à la Console Google Cloud Platform, Dans le panneau de navigation à gauche, cliquez sur "API & Services + ACTIVER LES API ET LES SERVICES".
- Recherchez et sélectionnez "Google Sheets API" dans la liste des API disponibles.
- Cliquez sur le bouton "Activer" pour activer l'API pour votre projet.
- Cliquez sur "Créer des identifiants" et sélectionnez "Clé API". 
- Copiez la clé API générée.

#### Autorisation de lecture et d'écriture :

- Autorisez la lecture et l'écriture de votre feuille de calcul sur Google Sheets.

#### Récupération du sheet name :

- Ouvrez votre document Google Sheets.
- Regardez le bas de la fenêtre du navigateur où les feuilles de calcul sont répertoriées. Vous verrez les onglets pour chaque feuille de calcul dans votre document.

#### Intégration de Google Sheets dans l'application pour modification de la feuille (Ajout d'étudiant)

#### Configurer l'API Google Sheets

3. **Créer un compte de service**:
    - Dans GCP, naviguez vers `Comptes de service` dans IAM et Administration.
    - Cliquez sur `Créer un compte de service`.
    - Donnez un nom au compte de service et attribuez le rôle `Éditeur` ou `Propriétaire` du projet.
    - Créez une clé au format JSON pour ce compte de service et téléchargez-la. Cette clé sera utilisée pour l'authentification dans votre application.

4. **Partager votre feuille Google Sheets** avec l'adresse e-mail du compte de service.

#### Intégrer l'API dans l'pplication Flutter

2. **Configurer l'authentification**:
    - Placez le fichier JSON de la clé du compte de service dans le dossier `assets/` et le chemin dans le fichier config.dart.


### Build avec un env Linux:

```shell
flutter build linux
```

### Build avec un env android:

```shell
flutter build apk
```

### Application

#### Affichage des données

![Affichage des données](assets/images/affichage.png)

#### Génération de PDF

![Génération de PDF](assets/images/pdf.png)
